package org.eaglei.search.provider;

import java.io.IOException;
import java.util.Collection;

/**
 * Interface for classes that can execute search requests on multiple destinations.
 * 
 * @author rfrost
 */
public interface MultiNodeSearchProvider {
    
    /**
     * Initializes the provider. Must be called before query or getInstitutions.
     * @throws IOException Thrown if an error is encountered initializing the provider.
     */
    public void init() throws IOException;
    
    /**
     * Executes the specified search request (potentially against multiple destinations) and returns a 
     * collection of SearchResultSets as a synchronous operation. 
     * One SearchResultSet will be returned from each destination in the network.
     * 
     * @param request The search request.
     * @return Collection of SearchResultSets. Will be empty before init has been called.
     * @throws IOException Thrown if an error is encountered executing the search.
     */
    public Collection<SearchResultSet> query(SearchRequest request) throws IOException;
    
    /**
     * Executes the specified search count request (potentially against multiple destinations) and returns a 
     * collection of SearchCounts as a synchronous operation. 
     * One SearchCounts will be returned from each destination in the network.
     * 
     * @param request The search counts request.
     * @return Collection of SearchCounts. Will be empty before init has been called.
     * @throws IOException Thrown if an error is encountered executing the search.
     */
    public Collection<SearchCounts> count(SearchCountRequest request) throws IOException;
    
}
