package org.eaglei.search.provider;

import java.io.IOException;

/**
 * Interface for classes that can execute search requests on a single node.
 * 
 * @author rfrost
 */
public interface SearchProvider {
    
    /**
     * Initializes the provider. Must be called before query or getInstitution
     * @throws IOException Thrown if an error is encountered initializing the provider.
     */
    public void init() throws IOException;
    
    /**
     * Executes the specified search request and returns a SearchResultSet as a
     * synchronous operation.
     * 
     * @param request The search request.
     * @return Set of search results. Will be empty before init has been called.
     * @throws IOException Thrown if an error is encountered executing the search. 
     */
    public SearchResultSet query(SearchRequest request) throws IOException;
    
    /**
     * Retrieves counts for a specific search request and returns a SearchCounts as a
     * synchronous operation.
     * 
     * @param request The search count request.
     * @return SearchCounts. Will be empty before init has been called.
     * @throws IOException Thrown if an error is encountered executing the search. 
     */
    public SearchCounts count(SearchCountRequest request) throws IOException;

}
