package org.eaglei.search.events;

import java.util.ArrayList;
import java.util.List;

import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;

/**
 * Container class for change event payloads (SearchResultSet, for now).
 * 
 * @author Rich Simon
 *
 */
public class ChangeEventPayloadImpl implements ChangeEventPayload {
	
	private SearchResultSet searchResultPayload;
	
	public ChangeEventPayloadImpl(SearchResultSet p) {
		searchResultPayload = p;
	}

	/* (non-Javadoc)
	 * @see org.eaglei.search.events.IChangeEventPayload#getChanges()
	 */
	@Override
	public List<ChangeEventPayloadItem> getChanges() {
		List<ChangeEventPayloadItem> changes = new ArrayList<ChangeEventPayloadItem>();
		List<SearchResult> results = searchResultPayload.getResults();
		for (SearchResult r : results) {
			changes.add(new ChangeEventPayloadItemImpl(r));
		}
    	return changes;
	}

	/* (non-Javadoc)
	 * @see org.eaglei.search.events.IChangeEventPayload#getTotalCount()
	 */
	@Override
	public int getTotalCount() {
		return searchResultPayload.getTotalCount();
	}

}
