package org.eaglei.search.events;

import java.util.Set;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

/**
 * Interface for classes the represent a change that requires 
 * updating the Lucene index. The defined methods return information
 * required to do the update.
 * 
 * @author Rich Simon
 *
 */
public interface ChangeEventPayloadItem {
	/**
     * Retrieves the EIEntity representing the resource instance.
     * 
     * @return The EIEntity.
     */
	public EIEntity getEntity();
    /**
     * Retrieves the EIEntity representing the resource type.
     * 
     * @return The type entity. Corresponds to a class in the eagle-i ontology. 
     */
	public EIEntity getType();
    /**
     * Retrieves the EIEntity representing the resource institution.
     * 
     * @return The institution entity.
     */
	public EIEntity getInstitution();
    /**
     * Returns the URIs (as EIURI instances) for the result data type properties.
     * 
     * @return Set of EIURIs representing a eagle-i ontology data type properties for the
     *         result.
     */
	public Set<EIURI> getDataTypeProperties();
    /**
     * Retrieves the values of the specified data type property.
     * 
     * @param property Property URI as an EIURI.
     * @return Values of the property if it has been set or null.
     */
	public Set<String> getDataTypeProperty(EIURI eiuri);
    /**
     * Returns the URIs (as EIURI instances) for the result object properties.
     * 
     * @return Set of EIURIs representing a eagle-i ontology properties for the
     *         result.
     */
	public Set<EIURI> getObjectProperties();
    /**
     * Retrieves the values of the specified object property.
     * 
     * @param property Property URI as an EIURI.
     * @return Values of the property if it has been set or null.
     */
	public Set<EIURI> getObjectProperty(EIURI eiuri);
}

