package org.eaglei.search.events;


/**
 * Class representing changes that require an update to the Lucene index.
 * 
 * @author Rich Simon
 *
 */
public class IndexChangeEvent {
	// Object containing the changes to the index
	private ChangeEventPayload payload;
	
	/**
	 * Create a change event with the given payload.
	 * 
	 * @param p Object describing the changes to the index
	 */
	public IndexChangeEvent(ChangeEventPayload p) {
		payload = p;
	}
	
	/**
	 * Retrieves the event payload.
	 * 
	 * @return IChangeEventgPayload
	 */
	public ChangeEventPayload getPayload() {
		return payload;
	}
}

