package org.eaglei.search.provider;

import java.io.Serializable;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

public class CountResult implements Serializable, Comparable<CountResult> {
    
    private EIEntity entity;
    private Integer count;
    private String definition; // lazily populated
    private boolean hasSubEntity;
    
    protected CountResult() {
    	// for gwt
    }
    
    public CountResult(EIEntity entity) {
        this(entity, 0);
    }

    public CountResult(EIEntity entity, int count) {
        // null entity is currently allowed, representing an "All" count
        // must be interpreted by the client
        this.entity = entity;
        this.count = count;
    }

	public CountResult(CountResult copy) {
		this(copy.getEntity(), copy.getCount());
	}

    public EIEntity getEntity() {
        return entity;
    }

    public Integer getCount() {
        return count;
    }
    
    public void increment() {
    	increment(1);
    }
    
    public void increment(int n) {
    	count += n;
    }
    
    public void decrement() {
    	decrement(1);
    }
    
    public void decrement(int n) {
    	count -= n;
    }
    
    public String getDefinition() {
    	return definition;
    }
    
    public void setDefinition(String definition) {
    	this.definition = definition;
    }
    
    public boolean hasSubEntity() {
    	return this.hasSubEntity;
    }
    
    public void setHasSubEntity(boolean hasSubEntity) {
    	this.hasSubEntity = hasSubEntity;
    }

    @Override
    public boolean equals(Object o) {
    	if (o instanceof EIURI) {
    		return (((EIURI) o).equals(getEntity().getURI()));
    	}
    	if (o instanceof EIEntity) {
    		return (((EIEntity) o).equals(getEntity()));
    	}
        if (o instanceof CountResult) {
    		return (((CountResult) o).equals(getEntity()));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return getEntity().hashCode();
    }
    
    @Override
    public int compareTo(CountResult o) {
    	// putting o.count first makes higher count appear first
        int result = o.count.compareTo(count);
        if (result == 0) {
            result = entity.compareTo(o.entity);
        }
        return result;
    }
    
    @Override
    public String toString() {
        return entity.toString() + "  (" + count + ")";
    }

}
