package org.eaglei.search.events;

import java.util.List;

/**
 * Interface for classes that can be payloads in an IndexChangeEvent.
 * 
 * @author Rich Simon
 *
 */
public interface ChangeEventPayload {
	/**
	 * Returns number of items in the payload.
	 * 
	 * @return int The number of items in the payload
	 */
	public int getTotalCount();
	/**
	 * Get the List of objects representing changes to the Lucene index.
	 * 
	 * @return List<IChangeEventPayloadItem>
	 */
	public List<ChangeEventPayloadItem> getChanges();
}
