package org.eaglei.search.provider;

import java.io.Serializable;
import java.util.List;
import java.util.SortedSet;

import org.eaglei.model.EIEntity;

public class ClassCountResult implements Serializable {
    
    /**
	 * 
	 */
	private static final long serialVersionUID = 2960981899017663228L;

	private SearchRequest request;
	
    // holds a total count, will have null entity for an All request
	private CountResult classCount;
	private List<CountResult> superClassCounts;
	private SortedSet<CountResult> subClassCounts;
	
	protected ClassCountResult() {
		// for gwt
		super();
	}
	
	public ClassCountResult(SearchRequest request) {
		this.request = request;
	}
	
	public EIEntity getEntity() {
		return this.classCount.getEntity();
	}

	public SearchRequest getSearchRequest() {
	    return this.request;
	}
	
	public void setClassCount(CountResult classCount) {
	    this.classCount = classCount;
	}
	
	public CountResult getClassCount() {
		return this.classCount;
	}

	public List<CountResult> getSuperClassCounts() {
		return superClassCounts;
	}

	public void setSuperClassCounts(List<CountResult> superClassCounts) {
		this.superClassCounts = superClassCounts;
	}

	public SortedSet<CountResult> getSubClassCounts() {
		return subClassCounts;
	}

	public void setSubClassCounts(SortedSet<CountResult> subClassCounts) {
		this.subClassCounts = subClassCounts;
	}

}
