/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;

public class SearchCounts
implements Serializable {
    public static final long serialVersionUID = 1L;
    private SearchRequest request;
    private Map<EIURI, Integer> classToCount;

    private SearchCounts() {
    }

    public SearchCounts(SearchRequest request) {
        this.request = request;
    }

    public SearchRequest getRequest() {
        return this.request;
    }

    public Set<EIURI> getClassesForCounts() {
        if (this.classToCount == null) {
            return Collections.EMPTY_SET;
        }
        return this.classToCount.keySet();
    }

    public void setClassCount(EIURI classURI, int count) {
        if (this.classToCount == null) {
            this.classToCount = new HashMap<EIURI, Integer>();
        }
        this.classToCount.put(classURI, count);
    }

    public int getClassCount(EIURI classURI) {
        if (this.classToCount == null || !this.classToCount.containsKey(classURI)) {
            return 0;
        }
        return this.classToCount.get(classURI);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SearchCounts)) {
            return false;
        }
        SearchCounts other = (SearchCounts)o;
        if (this.request == null ? other.request != null : !this.request.equals(other.request)) {
            return false;
        }
        return !(this.classToCount == null ? other.classToCount != null : !((Object)this.classToCount).equals(other.classToCount));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.request == null ? 0 : this.request.hashCode());
        result = 31 * result + (this.classToCount == null ? 0 : ((Object)this.classToCount).hashCode());
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.classToCount == null) {
            sb.append("null");
        } else {
            for (EIURI eiuri : this.classToCount.keySet()) {
                if (eiuri == null) {
                    sb.append("null");
                } else {
                    sb.append(eiuri.toString());
                }
                sb.append(": ");
                sb.append(this.classToCount.get(eiuri).toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

