/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eaglei.model.EIURI;

public class SearchRequest
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final DataSet DEFAULT_DATASET = DataSet.EI_RESOURCES;
    private static final String PARAM_DELIMITER = "&";
    private static final String DATASET_KEY = "ds";
    private static final String QUERY_KEY = "q";
    private static final String URI_KEY = "uri";
    private static final String INSTITUTION_KEY = "inst";
    private static final String RESOURCE_PROVIDER_URI_KEY = "rpu";
    private static final String RESOURCE_PROVIDER_TYPE_KEY = "rpt";
    private static final String RESOURCE_PROVIDER_INSTITUTION_KEY = "rpi";
    private static final String RESOURCE_PROVIDER_INSTITUTION_LBL = "rpl";
    private static final String TYPE_KEY = "t";
    private static final String DATATYPE_PROP_KEY = "dt_";
    private static final String OBJECT_PROP_KEY = "ob_";
    private static final String START_KEY = "start";
    private static final String MAX_KEY = "max";
    private DataSet dataset = DEFAULT_DATASET;
    private ResourceProvider provider;
    private Term term;
    private TypeBinding binding;
    private int startIndex = 0;
    private int maxResults = 10;

    public SearchRequest() {
    }

    public SearchRequest(Term term) {
        this.term = term;
    }

    public SearchRequest(String urlParams) {
        if (urlParams != null && urlParams.length() > 0) {
            String[] params;
            block4: for (String param : params = urlParams.split(PARAM_DELIMITER)) {
                String prop;
                EIURI uri;
                String[] parts = param.split("=");
                if (parts.length != 2) continue;
                if (parts[0].equals(QUERY_KEY)) {
                    if (this.term == null) {
                        this.term = new Term();
                    }
                    this.term.query = parts[1];
                    continue;
                }
                if (parts[0].equals(URI_KEY)) {
                    if (this.term == null) {
                        this.term = new Term();
                    }
                    uri = EIURI.create((String)parts[1]);
                    this.term.uri = uri;
                    continue;
                }
                if (parts[0].equals(RESOURCE_PROVIDER_URI_KEY)) {
                    if (this.provider == null) {
                        this.provider = new ResourceProvider();
                    }
                    uri = EIURI.create((String)parts[1]);
                    this.provider.uri = uri;
                    continue;
                }
                if (parts[0].equals(RESOURCE_PROVIDER_TYPE_KEY)) {
                    if (this.provider == null) {
                        this.provider = new ResourceProvider();
                    }
                    EIURI type = EIURI.create((String)parts[1]);
                    this.provider.type = type;
                    continue;
                }
                if (parts[0].equals(RESOURCE_PROVIDER_INSTITUTION_KEY)) {
                    if (this.provider == null) {
                        this.provider = new ResourceProvider();
                    }
                    EIURI institution = EIURI.create((String)parts[1]);
                    this.provider.institution = institution;
                    continue;
                }
                if (parts[0].equals(RESOURCE_PROVIDER_INSTITUTION_LBL)) {
                    if (this.provider == null) {
                        this.provider = new ResourceProvider();
                    }
                    this.provider.providerLabel = EIURI.create((String)parts[1]).toString();
                    continue;
                }
                if (parts[0].equals(TYPE_KEY)) {
                    if (this.binding == null) {
                        this.binding = new TypeBinding();
                    }
                    uri = EIURI.create((String)parts[1]);
                    this.binding.type = uri;
                    continue;
                }
                if (parts[0].equals(START_KEY)) {
                    try {
                        this.setStartIndex(Integer.valueOf(parts[1]));
                    }
                    catch (NumberFormatException ex) {}
                    continue;
                }
                if (parts[0].equals(MAX_KEY)) {
                    try {
                        this.setMaxResults(Integer.valueOf(parts[1]));
                    }
                    catch (NumberFormatException ex) {}
                    continue;
                }
                if (parts[0].equals(DATASET_KEY)) {
                    for (DataSet ds : DataSet.values()) {
                        if (!ds.toString().equals(parts[1])) continue;
                        this.dataset = ds;
                        continue block4;
                    }
                    continue;
                }
                if (parts[0].startsWith(DATATYPE_PROP_KEY)) {
                    if (this.binding == null) {
                        this.binding = new TypeBinding();
                    }
                    prop = parts[0].substring(DATATYPE_PROP_KEY.length());
                    EIURI uri2 = EIURI.create((String)prop);
                    this.binding.addDataTypeProperty(uri2, parts[1]);
                    continue;
                }
                if (!parts[0].startsWith(OBJECT_PROP_KEY)) continue;
                if (this.binding == null) {
                    this.binding = new TypeBinding();
                }
                prop = parts[0].substring(OBJECT_PROP_KEY.length());
                EIURI propURI = EIURI.create((String)prop);
                EIURI valueURI = EIURI.create((String)parts[1]);
                this.binding.addObjectProperty(propURI, valueURI);
            }
        }
    }

    public DataSet getDataset() {
        return this.dataset;
    }

    public void setDataset(DataSet dataset) {
        this.dataset = dataset;
    }

    public EIURI getProviderInstitution() {
        return this.provider != null ? this.provider.getInstitution() : null;
    }

    public void setProviderInstitution(EIURI institution) {
        if (this.provider != null) {
            this.provider.setInstitution(institution);
        } else {
            this.setProvider(new ResourceProvider(null, null, institution, null));
        }
    }

    public EIURI getProviderType() {
        return this.provider != null ? this.provider.getType() : null;
    }

    public void setProviderType(EIURI type) {
        if (this.provider != null) {
            this.provider.setType(type);
        } else {
            this.setProvider(new ResourceProvider(null, type, null, null));
        }
    }

    public ResourceProvider getProvider() {
        return this.provider;
    }

    public void setProvider(ResourceProvider location) {
        this.provider = location;
    }

    public Term getTerm() {
        return this.term;
    }

    public void setTerm(Term term) {
        this.term = term;
    }

    public EIURI getBindingType() {
        return this.binding != null ? this.binding.getType() : null;
    }

    public TypeBinding getBinding() {
        return this.binding;
    }

    public void setBinding(TypeBinding binding) {
        this.binding = binding;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        assert (startIndex >= 0);
        this.startIndex = startIndex;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        assert (maxResults >= 0);
        this.maxResults = maxResults;
    }

    public String toURLParams() {
        StringBuilder buf = new StringBuilder();
        if (this.term != null) {
            if (this.term.query != null && this.term.query.length() > 0) {
                buf.append(QUERY_KEY);
                buf.append("=");
                buf.append(this.term.query);
            }
            if (this.term.uri != null) {
                if (buf.length() > 0) {
                    buf.append(PARAM_DELIMITER);
                }
                buf.append(URI_KEY);
                buf.append("=");
                buf.append(this.term.uri.toString());
            }
        }
        if (this.dataset != null && this.dataset != DEFAULT_DATASET) {
            if (buf.length() > 0) {
                buf.append(PARAM_DELIMITER);
            }
            buf.append(DATASET_KEY);
            buf.append("=");
            buf.append((Object)this.dataset);
        }
        if (this.provider != null) {
            if (this.provider.uri != null) {
                if (buf.length() > 0) {
                    buf.append(PARAM_DELIMITER);
                }
                buf.append(RESOURCE_PROVIDER_URI_KEY);
                buf.append("=");
                buf.append(this.provider.uri.toString());
            }
            if (this.provider.type != null) {
                if (buf.length() > 0) {
                    buf.append(PARAM_DELIMITER);
                }
                buf.append(RESOURCE_PROVIDER_TYPE_KEY);
                buf.append("=");
                buf.append(this.provider.type.toString());
            }
            if (this.provider.institution != null) {
                if (buf.length() > 0) {
                    buf.append(PARAM_DELIMITER);
                }
                buf.append(RESOURCE_PROVIDER_INSTITUTION_KEY);
                buf.append("=");
                buf.append(this.provider.institution.toString());
            }
            if (this.provider.providerLabel != null) {
                if (buf.length() > 0) {
                    buf.append(PARAM_DELIMITER);
                }
                buf.append(RESOURCE_PROVIDER_INSTITUTION_LBL);
                buf.append("=");
                buf.append(this.provider.providerLabel);
            }
        }
        if (this.startIndex > 0) {
            if (buf.length() > 0) {
                buf.append(PARAM_DELIMITER);
            }
            buf.append(START_KEY);
            buf.append("=");
            buf.append(this.startIndex);
        }
        if (this.maxResults != 10) {
            if (buf.length() > 0) {
                buf.append(PARAM_DELIMITER);
            }
            buf.append(MAX_KEY);
            buf.append("=");
            buf.append(this.maxResults);
        }
        if (this.binding != null) {
            if (this.binding.type != null) {
                if (buf.length() > 0) {
                    buf.append(PARAM_DELIMITER);
                }
                buf.append(TYPE_KEY);
                buf.append("=");
                buf.append(this.binding.type.toString());
            }
            for (EIURI uri : this.binding.getDataTypeProperties()) {
                buf.append(PARAM_DELIMITER);
                buf.append(DATATYPE_PROP_KEY);
                buf.append(uri.toString());
                buf.append("=");
                buf.append(this.binding.getDataTypeProperty(uri));
            }
            for (EIURI uri : this.binding.getObjectProperties()) {
                buf.append(PARAM_DELIMITER);
                buf.append(OBJECT_PROP_KEY);
                buf.append(uri.toString());
                buf.append("=");
                buf.append(this.binding.getObjectProperty(uri));
            }
        }
        return buf.toString();
    }

    public String toString() {
        return this.toURLParams();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataset == null || this.dataset == DEFAULT_DATASET ? 0 : this.dataset.hashCode());
        result = 31 * result + (this.binding == null ? 0 : this.binding.hashCode());
        result = 31 * result + (this.provider == null ? 0 : this.provider.hashCode());
        result = 31 * result + this.maxResults;
        result = 31 * result + this.startIndex;
        result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        return this.equals(obj, false);
    }

    public boolean equals(Object obj, boolean exceptStartIndex) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchRequest other = (SearchRequest)obj;
        if (this.binding == null ? other.binding != null : !this.binding.equals(other.binding)) {
            return false;
        }
        if (this.dataset == null ? other.dataset != null : this.dataset != other.dataset) {
            return false;
        }
        if (this.provider == null ? other.provider != null : !this.provider.equals(other.provider)) {
            return false;
        }
        if (this.maxResults != other.maxResults) {
            return false;
        }
        if (!exceptStartIndex && this.startIndex != other.startIndex) {
            return false;
        }
        return !(this.term == null ? other.term != null : !this.term.equals(other.term));
    }

    public String getProviderTypeLabel() {
        return this.provider != null ? this.provider.getLabel() : null;
    }

    public void setProviderTypeLabel(String label) {
        if (this.provider != null) {
            this.provider.setLabel(label);
        } else {
            this.setProvider(new ResourceProvider(null, null, null, label));
        }
    }

    public static enum DataSet {
        EI_RESOURCES,
        NIF_RESOURCES,
        PUBS,
        GENES;

    }

    public static class ResourceProvider
    implements Serializable {
        public static final long serialVersionUID = 1L;
        private EIURI institution;
        private EIURI type;
        private EIURI uri;
        private String providerLabel;

        public ResourceProvider() {
        }

        public ResourceProvider(EIURI uri, EIURI type, EIURI institution, String label) {
            this.uri = uri;
            this.type = type;
            this.institution = institution;
            this.providerLabel = label;
        }

        public EIURI getURI() {
            return this.uri;
        }

        public void setURI(EIURI uri) {
            this.uri = uri;
        }

        public String getLabel() {
            return this.providerLabel;
        }

        public void setLabel(String label) {
            this.providerLabel = label;
        }

        public EIURI getType() {
            return this.type;
        }

        public void setType(EIURI type) {
            this.type = type;
        }

        public EIURI getInstitution() {
            return this.institution;
        }

        public void setInstitution(EIURI institution) {
            this.institution = institution;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.institution == null ? 0 : this.institution.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceProvider other = (ResourceProvider)obj;
            if (this.uri == null ? other.uri != null : !this.uri.equals((Object)other.uri)) {
                return false;
            }
            if (this.type == null ? other.type != null : !this.type.equals((Object)other.type)) {
                return false;
            }
            return !(this.institution == null ? other.institution != null : !this.institution.equals((Object)other.institution));
        }
    }

    public static class TypeBinding
    implements Serializable {
        public static final long serialVersionUID = 1L;
        private EIURI type;
        private Map<EIURI, String> datatypePropertyConstraints;
        private Map<EIURI, EIURI> objectPropertyConstraints;

        private TypeBinding() {
        }

        public TypeBinding(EIURI type) {
            this.setType(type);
        }

        public EIURI getType() {
            return this.type;
        }

        public void setType(EIURI type) {
            assert (type != null);
            this.type = type;
        }

        public Set<EIURI> getDataTypeProperties() {
            if (this.datatypePropertyConstraints == null) {
                return Collections.EMPTY_SET;
            }
            return this.datatypePropertyConstraints.keySet();
        }

        public void addDataTypeProperty(EIURI property, String value) {
            assert (property != null);
            assert (value != null);
            if (this.datatypePropertyConstraints == null) {
                this.datatypePropertyConstraints = new HashMap<EIURI, String>();
            }
            this.datatypePropertyConstraints.put(property, value);
        }

        public String getDataTypeProperty(EIURI property) {
            assert (property != null);
            if (this.datatypePropertyConstraints == null) {
                return null;
            }
            return this.datatypePropertyConstraints.get(property);
        }

        public Set<EIURI> getObjectProperties() {
            if (this.objectPropertyConstraints == null) {
                return Collections.EMPTY_SET;
            }
            return this.objectPropertyConstraints.keySet();
        }

        public void addObjectProperty(EIURI property, EIURI value) {
            assert (property != null);
            assert (value != null);
            if (this.objectPropertyConstraints == null) {
                this.objectPropertyConstraints = new HashMap<EIURI, EIURI>();
            }
            this.objectPropertyConstraints.put(property, value);
        }

        public EIURI getObjectProperty(EIURI property) {
            assert (property != null);
            if (this.objectPropertyConstraints == null) {
                return null;
            }
            return this.objectPropertyConstraints.get(property);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.datatypePropertyConstraints == null ? 0 : ((Object)this.datatypePropertyConstraints).hashCode());
            result = 31 * result + (this.objectPropertyConstraints == null ? 0 : ((Object)this.objectPropertyConstraints).hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeBinding other = (TypeBinding)obj;
            if (this.datatypePropertyConstraints == null ? other.datatypePropertyConstraints != null : !((Object)this.datatypePropertyConstraints).equals(other.datatypePropertyConstraints)) {
                return false;
            }
            if (this.objectPropertyConstraints == null ? other.objectPropertyConstraints != null : !((Object)this.objectPropertyConstraints).equals(other.objectPropertyConstraints)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
        }
    }

    public static class Term
    implements Serializable {
        public static final long serialVersionUID = 1L;
        private String query;
        private EIURI uri;

        private Term() {
        }

        public Term(String query, EIURI uri) {
            assert (query != null || uri != null);
            assert (query == null || query.length() > 0);
            this.query = query;
            this.uri = uri;
        }

        public Term(String query) {
            this(query, null);
        }

        public Term(EIURI uri) {
            this(null, uri);
        }

        public Term(Term term) {
            this(term.query, term.uri);
        }

        public String getQuery() {
            return this.query;
        }

        public EIURI getURI() {
            return this.uri;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
            result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Term other = (Term)obj;
            if (this.query == null ? other.query != null : !this.query.equals(other.query)) {
                return false;
            }
            return !(this.uri == null ? other.uri != null : !this.uri.equals((Object)other.uri));
        }
    }
}

