package org.eaglei.search.provider.ncbi.probe;

import java.io.IOException;
import java.util.Collections;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.ncbi.ESummary.ESummaryResult;
import org.eaglei.search.provider.ncbi.NCBISearchProvider;
import org.eaglei.search.provider.ncbi.probe.NCBIProbeProvider.ProbeSummary;
import org.eaglei.services.InstitutionRegistry;

/**
 * Subclass of NCBISearchProvider that wraps an NCBIProbeProvider.
 *
 * @author rfrost
 */
public final class NCBIProbeSearchProvider extends NCBISearchProvider {

    private static final Log logger = LogFactory.getLog(NCBIProbeSearchProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();

    public static final String REAGENT_URI = "http://purl.obolibrary.org/obo/ERO_0000006";
    private final EIEntity reagentEntity;    
    public static final String CONSTRUCT_URI = "http://purl.obolibrary.org/obo/ERO_0000285";
    private final EIEntity constructEntity;        
    private final EIEntity locationEntity;        
    
    public NCBIProbeSearchProvider(final EIOntModel eagleiOntModel, final InstitutionRegistry registry) {
        super(new NCBIProbeProvider(), eagleiOntModel, registry);
        this.reagentEntity = eagleiOntModel.getClass(EIURI.create(REAGENT_URI)).getEntity();        
        this.constructEntity = eagleiOntModel.getClass(EIURI.create(CONSTRUCT_URI)).getEntity(); 
        this.locationEntity = EIEntity.create(EIURI.create(NCBIProbeProvider.PROBE_URL), NCBIProbeProvider.NCBI_PROBE_NAME);        
    }
    
    public EIEntity getType() {
        return constructEntity;
    }    

    @Override
    public boolean shouldAddResults(SearchRequest request)
            throws IOException {
        final EIURI type = getType(request);
        if (type == null) { 
            return false;
        }
        return isType(type, constructEntity.getURI());
    }
     
    @Override
    protected SearchResult createSearchResultForDocSummary(ESummaryResult sum)
            throws IOException {
        final ProbeSummary probeSum = new ProbeSummary(sum);
        final SearchResult searchResult = new SearchResult(EIEntity.create(probeSum.url, probeSum.label),
                reagentEntity, null, locationEntity);
        searchResult.setURL(probeSum.url);
        searchResult.setHighlight(probeSum.title.value);
        
        return searchResult;
    }
    
    @Override
    protected String getQuery(SearchRequest request) throws IOException {
        return getQuery(request, true, Collections.singleton(constructEntity.getURI()), true);
    }    

}
