/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.ncbi;

import java.io.IOException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.ncbi.ESearch;
import org.eaglei.search.provider.ncbi.ESummary;
import org.eaglei.search.provider.ncbi.NCBIDBProvider;
import org.eaglei.services.InstitutionRegistry;
import org.w3c.dom.Document;

public abstract class NCBISearchProvider
implements SearchProvider {
    protected static final Log logger = LogFactory.getLog(NCBISearchProvider.class);
    protected static final boolean DEBUG = logger.isDebugEnabled();
    protected final NCBIDBProvider dbProvider;
    protected final EIOntModel eagleiOntModel;
    protected final InstitutionRegistry institutionRegistry;

    public NCBISearchProvider(NCBIDBProvider dbProvider, EIOntModel eagleiOntModel, InstitutionRegistry registry) {
        assert (dbProvider != null);
        assert (eagleiOntModel != null);
        assert (registry != null);
        this.dbProvider = dbProvider;
        this.eagleiOntModel = eagleiOntModel;
        this.institutionRegistry = registry;
    }

    public void init() throws IOException {
    }

    public SearchResultSet query(SearchRequest request) throws IOException {
        SearchResultSet resultSet = new SearchResultSet(request);
        if (request.getTerm() == null || request.getTerm().getQuery().length() == 0) {
            return resultSet;
        }
        if (!this.shouldAddResults(request)) {
            return resultSet;
        }
        String query = this.getQuery(request);
        ESearch.ESearchResult result = this.dbProvider.query(query, request.getStartIndex(), request.getMaxResults());
        resultSet.setTotalCount(result.count);
        resultSet.setStartIndex(request.getStartIndex());
        for (ESummary.ESummaryResult sum : ESummary.parseESummaryResult((Document)result.details)) {
            SearchResult searchResult = this.createSearchResultForDocSummary(sum);
            if (searchResult == null) continue;
            resultSet.getResults().add(searchResult);
        }
        return resultSet;
    }

    public SearchCounts count(SearchCountRequest countRequest) throws IOException {
        SearchRequest request = countRequest.getRequest();
        SearchCounts counts = new SearchCounts(request);
        for (EIURI type : countRequest.getCountTypes()) {
            SearchRequest searchRequest = new SearchRequest(request.toURLParams());
            if (type == null) {
                searchRequest.setBinding(null);
            } else {
                SearchRequest.TypeBinding binding = request.getBinding();
                if (binding == null) {
                    searchRequest.setBinding(new SearchRequest.TypeBinding(type));
                } else {
                    searchRequest.getBinding().setType(type);
                }
            }
            if (!this.shouldAddResults(searchRequest)) continue;
            String query = this.getQuery(searchRequest);
            ESearch.ESearchResult result = this.dbProvider.query(query, request.getStartIndex(), request.getMaxResults());
            counts.setClassCount(type, result.count);
        }
        return counts;
    }

    public abstract EIEntity getType();

    public abstract boolean shouldAddResults(SearchRequest var1) throws IOException;

    protected abstract String getQuery(SearchRequest var1) throws IOException;

    protected abstract SearchResult createSearchResultForDocSummary(ESummary.ESummaryResult var1) throws IOException;

    protected static EIURI getType(SearchRequest request) {
        SearchRequest.TypeBinding binding = request.getBinding();
        if (binding != null) {
            return binding.getType();
        }
        SearchRequest.Term term = request.getTerm();
        if (term != null && term.getURI() != null) {
            return term.getURI();
        }
        return null;
    }

    protected boolean isType(EIURI type, EIURI target) {
        if (type == null || target == null) {
            return false;
        }
        if (type.equals((Object)target)) {
            return true;
        }
        EIClass eiClass = this.eagleiOntModel.getClass(target);
        if (eiClass != null && eiClass.hasSubClass()) {
            for (EIClass sub : this.eagleiOntModel.getSubClasses(target)) {
                if (!this.isType(type, sub.getEntity().getURI())) continue;
                return true;
            }
        }
        return false;
    }

    protected String getQuery(SearchRequest request, boolean includeType, Set<EIURI> typesToIgnore, boolean includeInstitution) {
        EIURI uri;
        SearchRequest.TypeBinding binding;
        StringBuilder sb = new StringBuilder();
        SearchRequest.Term term = request.getTerm();
        if (term != null) {
            if (term.getQuery() != null) {
                sb.append(term.getQuery() + " ");
            }
            if (term.getURI() != null) {
                for (String label : this.eagleiOntModel.getLabels(term.getURI())) {
                    sb.append(label + " ");
                }
            }
        }
        if ((binding = request.getBinding()) != null && includeType && !typesToIgnore.contains(uri = binding.getType())) {
            for (String label : this.eagleiOntModel.getLabels(uri)) {
                sb.append(label + " ");
            }
        }
        if (request.getInstitution() != null && includeInstitution) {
            EIEntity entity = this.institutionRegistry.getInstitution(request.getInstitution());
            sb.append(entity.getLabel());
        }
        if (DEBUG) {
            logger.debug((Object)("Using NCBI query: " + sb.toString()));
        }
        return sb.toString();
    }
}

