/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.ncbi.probe;

import java.io.IOException;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.ncbi.ESummary;
import org.eaglei.search.provider.ncbi.NCBIDBProvider;
import org.eaglei.search.provider.ncbi.NCBISearchProvider;
import org.eaglei.search.provider.ncbi.probe.NCBIProbeProvider;
import org.eaglei.services.InstitutionRegistry;

public final class NCBIProbeSearchProvider
extends NCBISearchProvider {
    private static final Log logger = LogFactory.getLog(NCBIProbeSearchProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    public static final String REAGENT_URI = "http://purl.obolibrary.org/obo/ERO_0000006";
    private final EIEntity reagentEntity;
    public static final String CONSTRUCT_URI = "http://purl.obolibrary.org/obo/ERO_0000285";
    private final EIEntity constructEntity;
    private final EIEntity locationEntity;

    public NCBIProbeSearchProvider(EIOntModel eagleiOntModel, InstitutionRegistry registry) {
        super((NCBIDBProvider)new NCBIProbeProvider(), eagleiOntModel, registry);
        this.reagentEntity = eagleiOntModel.getClass(EIURI.create((String)REAGENT_URI)).getEntity();
        this.constructEntity = eagleiOntModel.getClass(EIURI.create((String)CONSTRUCT_URI)).getEntity();
        this.locationEntity = EIEntity.create((EIURI)EIURI.create((String)"http://www.ncbi.nlm.nih.gov/genome/probe/reports/probereport.cgi?uid="), (String)"NCBI Probe");
    }

    @Override
    public EIEntity getType() {
        return this.constructEntity;
    }

    @Override
    public boolean shouldAddResults(SearchRequest request) throws IOException {
        EIURI type = NCBIProbeSearchProvider.getType(request);
        if (type == null) {
            return false;
        }
        return this.isType(type, this.constructEntity.getURI());
    }

    @Override
    protected SearchResult createSearchResultForDocSummary(ESummary.ESummaryResult sum) throws IOException {
        NCBIProbeProvider.ProbeSummary probeSum = new NCBIProbeProvider.ProbeSummary(sum);
        SearchResult searchResult = new SearchResult(EIEntity.create((String)probeSum.url, (String)probeSum.label), this.reagentEntity, null, this.locationEntity);
        searchResult.setURL(probeSum.url);
        searchResult.setHighlight(probeSum.title.value);
        return searchResult;
    }

    @Override
    protected String getQuery(SearchRequest request) throws IOException {
        return this.getQuery(request, true, Collections.singleton(this.constructEntity.getURI()), true);
    }

    public ClassCountResult getResourceCount(SearchRequest request) {
        return null;
    }
}

