/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.ncbi;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.search.provider.ncbi.NCBIEUtils;
import org.w3c.dom.Document;

public abstract class NCBIDBProvider {
    protected static final Log logger = LogFactory.getLog(NCBIDBProvider.class);
    protected static final boolean DEBUG = logger.isDebugEnabled();
    protected static final String EAGLEI_TOOL = "eaglei";
    protected final String entrezDB;

    public NCBIDBProvider(String entrezDB) {
        assert (entrezDB != null);
        this.entrezDB = entrezDB;
    }

    public NCBIEUtils.ESearchResult query(String query, int startIndex, int maxResults) throws IOException {
        String searchURL = NCBIEUtils.buildSearchURL(query, this.entrezDB, EAGLEI_TOOL, startIndex, maxResults);
        if (DEBUG) {
            logger.debug((Object)("Querying NCBI eSearch service at " + searchURL));
        }
        Document doc = NCBIEUtils.executeNCBIRequest(searchURL);
        NCBIEUtils.ESearchResult result = NCBIEUtils.parseESearchResult(doc);
        if (!result.ids.isEmpty()) {
            String summaryURL = NCBIEUtils.buildSummaryURL(result, this.entrezDB, EAGLEI_TOOL);
            if (DEBUG) {
                logger.debug((Object)("Querying NCBI eSummary at " + summaryURL));
            }
            doc = NCBIEUtils.executeNCBIRequest(summaryURL);
            List<NCBIEUtils.DocSummary> docs = NCBIEUtils.parseESummaryResult(doc);
            if (DEBUG) {
                logger.debug((Object)("Retrieved " + docs.size() + " summary documents"));
            }
            result.docs.addAll(docs);
        }
        return result;
    }
}

