/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.ncbi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class NCBIEUtils {
    private static final Log logger = LogFactory.getLog(NCBIEUtils.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private static final String EUTILS_SEARCH_URL = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?";
    private static final String EUTILS_SUMMARY_URL = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esummary.fcgi?";
    private static final String DB = "db=";
    private static final String TERM = "term=";
    private static final String RETMAX = "retmax=";
    private static final String RETSTART = "retstart=";
    private static final String TOOL = "tool=";
    private static final String ID_PARAM = "id=";
    private static final String RETMODE = "retmode=";
    public static final String IDLIST = "IdList";
    public static final String ID = "Id";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document executeNCBIRequest(String url) throws IOException {
        HttpClient httpclient = new HttpClient();
        GetMethod httpget = new GetMethod(url);
        InputStream is = null;
        try {
            Document doc;
            httpclient.executeMethod((HttpMethod)httpget);
            is = httpget.getResponseBodyAsStream();
            Document document = doc = NCBIEUtils.parse(is);
            return document;
        }
        finally {
            httpget.releaseConnection();
            if (is != null) {
                is.close();
            }
        }
    }

    public static String serializeDocument(Document doc) {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            return writer.writeToString(doc);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String buildSearchURL(String query, String db, String tool, int start, int max) {
        StringBuilder sb = new StringBuilder();
        sb.append(EUTILS_SEARCH_URL);
        sb.append("&db=" + db);
        sb.append("&tool=" + tool);
        sb.append("&term=" + URLEncoder.encode(query));
        sb.append("&retmode=xml");
        sb.append("&retstart=" + start);
        sb.append("&retmax=" + max);
        return sb.toString();
    }

    public static String buildSummaryURL(ESearchResult result, String db, String tool) {
        StringBuilder sb = new StringBuilder();
        sb.append(EUTILS_SUMMARY_URL);
        sb.append("&db=" + db);
        sb.append("&tool=" + tool);
        sb.append("&id=");
        boolean first = true;
        for (String id : result.ids) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(id);
        }
        sb.append("&retmode=xml");
        sb.append("&retmax=" + result.max);
        return sb.toString();
    }

    public static ESearchResult parseESearchResult(Document doc) throws IOException {
        Element eSearchResult = doc.getDocumentElement();
        NodeList children = eSearchResult.getChildNodes();
        ESearchResult result = new ESearchResult();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals(IDLIST)) {
                NodeList idNodes = node.getChildNodes();
                for (int j = 0; j < idNodes.getLength(); ++j) {
                    Node idNode = idNodes.item(j);
                    if (!idNode.getNodeName().equals(ID)) continue;
                    result.ids.add(idNode.getTextContent());
                }
                continue;
            }
            if (nodeName.equals("Count")) {
                result.count = Integer.parseInt(node.getTextContent());
                continue;
            }
            if (nodeName.equals("RetMax")) {
                result.max = Integer.parseInt(node.getTextContent());
                continue;
            }
            if (!nodeName.equals("RetStart")) continue;
            result.start = Integer.parseInt(node.getTextContent());
        }
        return result;
    }

    public static List<DocSummary> parseESummaryResult(Document doc) throws IOException {
        Element eSummaryResult = doc.getDocumentElement();
        NodeList children = eSummaryResult.getChildNodes();
        ArrayList<DocSummary> docs = new ArrayList<DocSummary>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            String nodeName = node.getNodeName();
            if (!nodeName.equals("DocSum")) continue;
            DocSummary docSum = new DocSummary();
            docs.add(docSum);
            NodeList idNodes = node.getChildNodes();
            for (int j = 0; j < idNodes.getLength(); ++j) {
                Node child = idNodes.item(j);
                if (child.getNodeName().equals(ID)) {
                    docSum.id = child.getTextContent();
                    continue;
                }
                if (!child.getNodeName().equals("Item")) continue;
                Item item = NCBIEUtils.parseItem(child);
                if (!docSum.items.containsKey(item.name)) {
                    docSum.items.put(item.name, new ArrayList());
                }
                docSum.items.get(item.name).add(item);
            }
        }
        return docs;
    }

    private static Item parseItem(Node itemNode) throws IOException {
        String type = itemNode.getAttributes().getNamedItem("Type").getNodeValue();
        Item item = null;
        if (type.equals("List") || type.equals("Structure")) {
            item = new ListItem();
            NodeList idNodes = itemNode.getChildNodes();
            for (int j = 0; j < idNodes.getLength(); ++j) {
                Node child = idNodes.item(j);
                if (!child.getNodeName().equals("Item")) continue;
                Item childItem = NCBIEUtils.parseItem(child);
                if (!item.items.containsKey(childItem.name)) {
                    item.items.put(childItem.name, new ArrayList());
                }
                item.items.get(childItem.name).add(childItem);
            }
        } else {
            item = new Item();
            item.value = itemNode.getTextContent();
        }
        item.name = itemNode.getAttributes().getNamedItem("Name").getNodeValue();
        return item;
    }

    public static Document parse(InputStream stream) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(stream));
        }
        catch (SAXException saxe) {
            throw new IOException(saxe);
        }
        catch (ParserConfigurationException pce) {
            throw new IOException(pce);
        }
    }

    public static class ListItem
    extends Item {
        public Map<String, List<Item>> items = new HashMap<String, List<Item>>();
    }

    public static class Item {
        public String name;
        public String type;
        public String value;
    }

    public static class DocSummary {
        public String id;
        public Map<String, List<Item>> items = new HashMap<String, List<Item>>();
    }

    public static class ESearchResult {
        public List<String> ids = new ArrayList<String>();
        public List<DocSummary> docs = new ArrayList<DocSummary>();
        public int count;
        public int start;
        public int max;
    }
}

