/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.ncbi;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.search.provider.ncbi.EUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ESearch
extends EUtils {
    private static final Log logger = LogFactory.getLog(ESearch.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private static final String EUTILS_SEARCH_URL = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?";

    public static ESearchResult search(String query, String db, String tool, int startIndex, int maxResults) throws IOException {
        String searchURL = ESearch.buildSearchURL(query, db, tool, startIndex, maxResults);
        if (DEBUG) {
            logger.debug((Object)("Querying NCBI eSearch service at " + searchURL));
        }
        Document doc = EUtils.executeNCBIRequest(searchURL);
        return new ESearchResult(doc);
    }

    public static String buildSearchURL(String query, String db, String tool, int start, int max) {
        StringBuilder sb = new StringBuilder();
        sb.append(EUTILS_SEARCH_URL);
        sb.append("&db=" + db);
        sb.append("&tool=" + tool);
        sb.append("&term=" + URLEncoder.encode(query));
        sb.append("&retmode=xml");
        sb.append("&retstart=" + start);
        sb.append("&retmax=" + max);
        return sb.toString();
    }

    public static class ESearchResult {
        public int count;
        public int start;
        public int max;
        public String queryTranslation;
        public List<String> ids = new ArrayList<String>();
        public Document details;

        public ESearchResult(Document doc) throws IOException {
            Element eSearchResult = doc.getDocumentElement();
            NodeList children = eSearchResult.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.equals("IdList")) {
                    NodeList idNodes = node.getChildNodes();
                    for (int j = 0; j < idNodes.getLength(); ++j) {
                        Node idNode = idNodes.item(j);
                        if (!idNode.getNodeName().equals("Id")) continue;
                        this.ids.add(idNode.getTextContent());
                    }
                    continue;
                }
                if (nodeName.equals("Count")) {
                    this.count = Integer.parseInt(node.getTextContent());
                    continue;
                }
                if (nodeName.equals("RetMax")) {
                    this.max = Integer.parseInt(node.getTextContent());
                    continue;
                }
                if (nodeName.equals("RetStart")) {
                    this.start = Integer.parseInt(node.getTextContent());
                    continue;
                }
                if (!nodeName.equals("QueryTranslation")) continue;
                this.queryTranslation = node.getTextContent();
            }
        }
    }
}

