/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.nif;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class NIFQueryUtil {
    public static final String EUTILS_URL = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/";
    public static final String DB = "db=";
    public static final String TERM = "term=";
    public static final String RETMAX = "retmax=";
    public static final String RETSTART = "retstart=";
    public static final String TOOL = "tool=";
    public static final String ID_PARAM = "id=";
    public static final String RETMODE = "retmode=";
    public static final String IDLIST = "IdList";
    public static final String ID = "Id";
    private static final Log logger = LogFactory.getLog(NIFQueryUtil.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private static final String EUTILS_SEARCH_URL = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?";
    private static final String NIF_SEARCH_URL = "http://nif-services.neuinfo.org/nif/services/federationQuery/";
    private static final String NIF_MOUSE_DB = "IMSR/Mice";

    public static Document search(String query, String db, String tool, int startIndex, int maxResults) throws IOException {
        String searchURL = NIFQueryUtil.buildSearchURL(query, db, tool, startIndex, maxResults);
        if (DEBUG) {
            logger.debug((Object)("Querying NIF search service at " + searchURL));
        }
        Document doc = NIFQueryUtil.executeNIFRequest(searchURL);
        return doc;
    }

    public static String buildSearchURL(String query, String db, String tool, int start, int max) {
        StringBuilder sb = new StringBuilder();
        sb.append(NIF_SEARCH_URL);
        sb.append(NIF_MOUSE_DB);
        sb.append("?");
        sb.append("q=" + URLEncoder.encode(query));
        sb.append("&");
        sb.append("offset=" + start);
        sb.append("&");
        sb.append("count=" + max);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document executeNIFRequest(String url) throws IOException {
        HttpClient httpclient = new HttpClient();
        httpclient.getParams().setParameter("accept", (Object)"application/xml");
        GetMethod httpget = new GetMethod(url);
        InputStream is = null;
        try {
            Document doc;
            httpclient.executeMethod((HttpMethod)httpget);
            is = httpget.getResponseBodyAsStream();
            Document document = doc = NIFQueryUtil.parse(is);
            return document;
        }
        finally {
            httpget.releaseConnection();
            if (is != null) {
                is.close();
            }
        }
    }

    private static Document parse(InputStream stream) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(stream));
        }
        catch (SAXException saxe) {
            throw new IOException(saxe);
        }
        catch (ParserConfigurationException pce) {
            throw new IOException(pce);
        }
    }

    public static String buildServiceURL(String serviceURL, List<String> ids, String db, int max, String tool) {
        StringBuilder sb = new StringBuilder();
        sb.append(serviceURL);
        sb.append("&db=" + db);
        sb.append("&tool=" + tool);
        sb.append("&id=");
        for (int i = 0; i < max && i < ids.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(ids.get(i));
        }
        sb.append("&retmode=xml");
        sb.append("&retmax=" + max);
        return sb.toString();
    }

    public static String serializeDocument(Document doc) {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            return writer.writeToString(doc);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class ESearchResult {
        public int count;
        public int start;
        public int max;
        public String queryTranslation;
        public List<String> ids = new ArrayList<String>();
        public Document details;

        public ESearchResult(Document doc) throws IOException {
            Element eSearchResult = doc.getDocumentElement();
            NodeList children = eSearchResult.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.equals(NIFQueryUtil.IDLIST)) {
                    NodeList idNodes = node.getChildNodes();
                    for (int j = 0; j < idNodes.getLength(); ++j) {
                        Node idNode = idNodes.item(j);
                        if (!idNode.getNodeName().equals(NIFQueryUtil.ID)) continue;
                        this.ids.add(idNode.getTextContent());
                    }
                    continue;
                }
                if (nodeName.equals("Count")) {
                    this.count = Integer.parseInt(node.getTextContent());
                    continue;
                }
                if (nodeName.equals("RetMax")) {
                    this.max = Integer.parseInt(node.getTextContent());
                    continue;
                }
                if (nodeName.equals("RetStart")) {
                    this.start = Integer.parseInt(node.getTextContent());
                    continue;
                }
                if (!nodeName.equals("QueryTranslation")) continue;
                this.queryTranslation = node.getTextContent();
            }
        }
    }
}

