/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.driver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.network.driver.SSLUtilities;
import org.eaglei.search.common.SerializationException;
import org.eaglei.search.common.Serializer;
import org.eaglei.search.provider.MultiNodeSearchProvider;
import org.eaglei.search.provider.SearchProviderUtil;
import org.eaglei.search.request.SearchRequest;
import org.eaglei.search.request.SearchResult;
import org.eaglei.search.request.SearchResultSet;
import org.spin.node.acknack.AckNack;
import org.spin.node.connector.NodeConnector;
import org.spin.query.message.agent.AgentException;
import org.spin.query.message.agent.Querier;
import org.spin.query.message.agent.TimeoutException;
import org.spin.query.message.identity.IdentityService;
import org.spin.query.message.identity.IdentityServiceException;
import org.spin.query.message.identity.local.LocalAuthEntry;
import org.spin.query.message.identity.local.LocalIdentityService;
import org.spin.tools.Util;
import org.spin.tools.config.AgentConfig;
import org.spin.tools.config.ConfigException;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.EndpointType;
import org.spin.tools.crypto.signature.Identity;

public final class EagleISpinQuerier
implements MultiNodeSearchProvider {
    private static final Logger log = Logger.getLogger(EagleISpinQuerier.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    static final Float DefaultPollingFrequency = Float.valueOf(5.0f);
    static final String DefaultPeerGroup = "EAGLE-I-TEST";
    static final Querier.Credentials DefaultCredentials = new Querier.Credentials("eagle-i.org", "eagle-i-search-app", "eagle-i-search-app");
    private final Querier querier;
    private final String queryType;
    private Collection<EIEntity> institutions;

    public EagleISpinQuerier(String entryPointNodeURL, String queryType) throws IOException {
        this(EagleISpinQuerier.makeAgentConfig(entryPointNodeURL), queryType, null);
    }

    EagleISpinQuerier(AgentConfig agentConfig, String queryType, NodeConnector nodeConnector) throws IOException {
        assert (agentConfig != null);
        assert (queryType != null);
        SSLUtilities.trustAllHttpsCertificates();
        SSLUtilities.trustAllHostnames();
        this.queryType = queryType;
        try {
            this.querier = nodeConnector == null ? new Querier(agentConfig, Holder.identityService) : new Querier(agentConfig, Holder.identityService, nodeConnector);
        }
        catch (Exception e) {
            throw new IOException("Error creating Querier: ", e);
        }
        if (INFO) {
            log.info((Object)("Created " + EagleISpinQuerier.class.getSimpleName() + " for peer group '" + agentConfig.getPeerGroupToQuery() + "', using query type '" + queryType + "' and entry point " + agentConfig.getNodeConnectorEndpoint()));
        }
    }

    String getQueryType() {
        return this.queryType;
    }

    public synchronized void init() throws IOException {
        this.institutions = SearchProviderUtil.getInstitutions((MultiNodeSearchProvider)this);
    }

    public synchronized Collection<EIEntity> getInstitutions() {
        return this.institutions;
    }

    public Collection<SearchResultSet> query(SearchRequest searchRequest) throws IOException {
        Collection<Object> results;
        assert (searchRequest != null);
        if (DEBUG) {
            log.debug((Object)("making query with type: '" + this.queryType + "'"));
        }
        String serializedSearchRequest = this.serializeSearchRequest(searchRequest);
        AckNack ack = this.submitQuery(serializedSearchRequest);
        Identity identity = this.certifyIdentity();
        boolean timeoutOccurred = false;
        try {
            results = this.querier.receive(ack, identity);
        }
        catch (TimeoutException e) {
            timeoutOccurred = true;
            results = this.getAvailableResultsForTimedOutQuery(ack, identity);
        }
        catch (AgentException e) {
            throw new IOException("Error receiving the query '" + ack.getQueryID() + "': ", e);
        }
        if (DEBUG) {
            log.debug((Object)("Raw, unmarshalled results: " + results));
        }
        return EagleISpinQuerier.setMetadataFields(timeoutOccurred, EagleISpinQuerier.unmarshalResults(results));
    }

    private static Collection<SearchResultSet> setMetadataFields(boolean timeoutOccurred, Collection<SearchResultSet> resultSets) {
        if (timeoutOccurred) {
            for (SearchResultSet resultSet : resultSets) {
                resultSet.setWasTimeout(true);
                resultSet.setInstitutionsIncluded(EagleISpinQuerier.getInstitutionsPresentInResults(resultSet));
            }
        }
        return resultSets;
    }

    private static List<EIURI> getInstitutionsPresentInResults(SearchResultSet resultSet) {
        assert (resultSet != null);
        HashSet institutions = Util.makeHashSet();
        for (SearchResult result : resultSet.getResults()) {
            institutions.add(result.getInstitution().getURI());
        }
        return Util.makeArrayList((Collection)institutions);
    }

    private String serializeSearchRequest(SearchRequest searchRequest) throws IOException {
        try {
            return Serializer.SearchRequestSerializer.serialize((Object)searchRequest);
        }
        catch (SerializationException e) {
            throw new IOException("Error serializing SearchRequest: ", e);
        }
    }

    private Identity certifyIdentity() throws IOException {
        try {
            return this.querier.getIdentityService().certify(DefaultCredentials.getDomain(), DefaultCredentials.getUsername(), DefaultCredentials.getPassword());
        }
        catch (IdentityServiceException e) {
            throw new IOException("Error sending query: couldn't certify credentials: " + DefaultCredentials);
        }
    }

    private Collection<String> getAvailableResultsForTimedOutQuery(AckNack ack, Identity identity) throws IOException {
        assert (ack != null);
        assert (identity != null);
        try {
            return this.querier.decryptResults(this.querier.getAgent().getResultNoDelete(ack.getQueryID(), identity));
        }
        catch (Exception e) {
            throw new IOException("Error getting results of timed-out query '" + ack.getQueryID() + "'");
        }
    }

    private AckNack submitQuery(String serializedSearchRequest) throws IOException {
        try {
            return this.querier.queryAsync(this.queryType, DefaultCredentials, serializedSearchRequest);
        }
        catch (AgentException e) {
            throw new IOException("Error submitting the Query: (queryType: '" + this.queryType + "')", e);
        }
    }

    private static Collection<SearchResultSet> unmarshalResults(Collection<String> results) {
        assert (results != null);
        ArrayList unmarshalled = Util.makeArrayList((int)results.size());
        for (String json : results) {
            if (json != null) {
                try {
                    SearchResultSet resultSet = (SearchResultSet)Serializer.SearchResultSetSerializer.deserialize(json);
                    if (DEBUG) {
                        log.debug((Object)("Unmarshalled SearchResultSet with " + resultSet.getTotalCount() + " results"));
                    }
                    unmarshalled.add(resultSet);
                }
                catch (SerializationException e) {
                    log.error((Object)"Error deserializing result, proceeding with others: ", (Throwable)e);
                    if (!DEBUG) continue;
                    log.debug((Object)("Raw results that couldn't be deserialized: '" + json + "'"));
                }
                continue;
            }
            log.warn((Object)"Result is null, skipping deserialization and proceeding with others");
            unmarshalled.add(null);
        }
        if (INFO) {
            log.info((Object)("Got results from " + unmarshalled.size() + " repositories"));
        }
        return unmarshalled;
    }

    static final IdentityService makeIdentityService() {
        return new LocalIdentityService(Arrays.asList(new LocalAuthEntry(DefaultCredentials.getDomain(), DefaultCredentials.getUsername(), DefaultCredentials.getPassword(), "user")));
    }

    private static AgentConfig makeAgentConfig(String entryPointNodeURL) {
        assert (entryPointNodeURL != null);
        try {
            return ConfigTool.loadAgentConfig();
        }
        catch (ConfigException e) {
            if (INFO) {
                log.info((Object)"Couldn't load agent.xml from the filesystem or classpath, using defaults.");
            }
            AgentConfig config = new AgentConfig();
            config.setMaxWaitTime(60000L);
            config.setPollingFrequency(DefaultPollingFrequency);
            config.setPeerGroupToQuery(DefaultPeerGroup);
            config.setNodeConnectorEndpoint(new EndpointConfig(EndpointType.SOAP, entryPointNodeURL));
            return config;
        }
    }

    static final class Holder {
        static final IdentityService identityService = EagleISpinQuerier.makeIdentityService();

        Holder() {
        }
    }
}

