package org.eaglei.network.driver;

import static org.spin.tools.Util.guardNotNull;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;
import org.spin.tools.Util;

/**
 * 
 * @author Clint Gilbert
 * 
 * Oct 19, 2010
 *
 * Center for Biomedical Informatics (CBMI)
 * @link https://cbmi.med.harvard.edu/
 *
 * @param <R>
 */
public abstract class QueryWrapUpStrategy<R> {
    private QueryWrapUpStrategy() {
        super();
    }

    abstract Collection<R> wrapUp(final boolean timeoutOccurred, final Collection<R> results);
    
    @SuppressWarnings("synthetic-access")
    private static final QueryWrapUpStrategy<Object> PassThroughStrategy = new QueryWrapUpStrategy<Object>() {
        @Override
        Collection<Object> wrapUp(final boolean timeoutOccurred, final Collection<Object> results) {
            return results;
        }
    };
    
    @SuppressWarnings("unchecked")
    public static final <R> QueryWrapUpStrategy<R> passThrough() {
        return (QueryWrapUpStrategy<R>)PassThroughStrategy;
    }
    
    @SuppressWarnings("synthetic-access")
    public static final QueryWrapUpStrategy<SearchResultSet> SearchResultSet = new QueryWrapUpStrategy<SearchResultSet>() {
        @Override
        Collection<SearchResultSet> wrapUp(final boolean timeoutOccurred, final Collection<SearchResultSet> results) {
            return setMetadataFields(timeoutOccurred, results);
        }
    };
    
    private static Collection<SearchResultSet> setMetadataFields(final boolean timeoutOccurred, final Collection<SearchResultSet> resultSets) {
        if(timeoutOccurred) {
            for(final SearchResultSet resultSet : resultSets) {
                resultSet.setWasTimeout(true);

                resultSet.setInstitutionsIncluded(getInstitutionsPresentInResults(resultSet));
            }
        }

        return resultSets;
    }
    
    public static List<EIURI> getInstitutionsPresentInResults(final SearchResultSet resultSet) {
        guardNotNull(resultSet);

        final Set<EIURI> institutions = Util.makeHashSet();

        for(final SearchResult result : resultSet.getResults()) {
            institutions.add(result.getInstitution().getURI());
        }

        return Util.makeArrayList(institutions);
    }
}
