package org.eaglei.services.repository;

import org.eaglei.services.InstitutionRegistry;

/**
 * Configuration for connecting to the repository.
 */
public final class RepositoryHttpClient {

    public static final String EAGLEI_REPOSITORY_USERNAME_PROPERTY = "org.eaglei.repository.username";
    public static final String EAGLEI_REPOSITORY_PASSWORD_PROPERTY = "org.eaglei.repository.password";
    public static final String PUBLISHED_NG = "http://eagle-i.org/ont/repo/1.0/NG_Published";
    public static final String DEFAULT_NG = "http://eagle-i.org/ont/repo/1.0/NG_DefaultWorkspace";

    // Username for basic http auth
    private String username = null;
    // Password for basic http auth
    private String password = null;
    // URI of default graph for query; optional
    private String defaultGraphURI = PUBLISHED_NG;
    // Repository view (see repo spec for details)
    private String view = "published-resources";

    private String whoamiUrl;
    private String logoutUrl;
    private String sparqlUrl;
    private String harvestUrl;
    
    public RepositoryHttpClient(String institutionSubdomain) {
        this(institutionSubdomain, 
                System.getProperty(EAGLEI_REPOSITORY_USERNAME_PROPERTY),
                System.getProperty(EAGLEI_REPOSITORY_PASSWORD_PROPERTY));
    }
    
    
    public RepositoryHttpClient(String institutionSubdomain, String username, String password) {
        assert(institutionSubdomain != null);
        String tier = System.getProperty(InstitutionRegistry.EAGLEI_TIER_PROPERTY);
        String baseUrl = computeBaseUrl(tier, institutionSubdomain);
        this.whoamiUrl = baseUrl + "whoami";
        this.logoutUrl = baseUrl + "logout/";
        this.sparqlUrl = baseUrl + "sparql";
        this.harvestUrl = baseUrl + "harvest";
        setUsername(username);
        setPassword(password);
    }

    private String computeBaseUrl(String tier, String institutionSubdomain) {
        StringBuilder buf = new StringBuilder();
        buf.append("https://");
        if (tier == null || tier.toLowerCase().equals("prod")) {
            
        } else {
            buf.append(tier.toLowerCase());
            buf.append('.');
        }
        buf.append(institutionSubdomain.toLowerCase());
        buf.append(".eagle-i.net/repository/");
        return buf.toString();
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return password;
    }

    public String getView() {
        return this.view;
    }

    public void setView(final String view) {
        this.view = view;
    }

    public void setDefaultGraphURI(final String defaultGraphURI) {
        this.defaultGraphURI = defaultGraphURI;
    }

    public String getDefaultGraphURI() {
        return this.defaultGraphURI;
    }
    
    public String getWhoamiUrl() {
        return this.whoamiUrl;
    }
    
    public String getLogoutUrl() {
        return this.logoutUrl;
    }
    
    public String getHarvestUrl() {
        return this.harvestUrl;
    }
    
    public String getSparqlUrl() {
        return this.sparqlUrl;
    }

}
