package org.eaglei.ui.gwt;

import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.VersionCallback;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

public class FooterPanel extends Composite {

    interface Binder extends UiBinder<Widget, FooterPanel> {
    }

    private static final Binder binder = GWT.create(Binder.class);

    @UiField
    Label appVersionLabel;
    @UiField
    Label ontVersionLabel;
    
    public FooterPanel() {
        this("");
    }
    
    public FooterPanel(String version) {
        initWidget(binder.createAndBindUi(this));
        appVersionLabel.setText(appVersionLabel.getText() + version);
        DeferredCommand.addCommand(new Command() {

            @Override
            public void execute() {
                ClientModelManager.INSTANCE.getVersion(new VersionCallback() {

                    @Override
                    public void onSuccess(String result) {
                        if (result != null) {
                            ontVersionLabel.setText(ontVersionLabel.getText() + result);
                        }
                    }
                    
                });
            }
            
        });
    }
   
}
