package org.eaglei.ui.gwt.home;

import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.search.SearchBar;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.SearchBar.SearchRequestListener;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;

public class HomePage extends Composite {

	interface MyUiBinder extends UiBinder<Widget, HomePage> {
	}

	private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);

	@UiField
	SearchBar searchBar;

	public HomePage() {
		initWidget(uiBinder.createAndBindUi(this));
		searchBar.addSearchRequestListener(new SearchRequestListener() {

			@Override
			public void onRequest(SearchRequest request) {
                SearchContext.INSTANCE.search(request, false);
			}

		});
		searchBar.sizeToParent(960);
	}

	public void setPageParams(String params) {
        SearchRequest request = new SearchRequest(params);
        SearchContext.INSTANCE.setCurrentRequest(request);
        if (params == null || params.length() == 0) {
            SearchContext.INSTANCE.clearSearch();
        } else {
            // Support search request params
        }

	}

}
