package org.eaglei.ui.gwt.search.results;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassCallback;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchRequest.TypeBinding;
import org.eaglei.suggest.client.SharedClassChooser;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;

public class FilterPanel extends Composite{
    
    class PropertyFilter extends HorizontalPanel {
        PropertyFilter(String label) {
            add(new Label(label));
        }
    }
        
    class TypePropertyFilter extends PropertyFilter {

        private final SharedClassChooser<OntologyDropdown> subTypeChooser;

        TypePropertyFilter() {
            super("Type:");
            subTypeChooser = new SharedClassChooser<OntologyDropdown>(new OntologyDropdown());
            subTypeChooser.setTextBoxStyle("formText");
            add(subTypeChooser);
        }
        
        private void setClass(EIClass typeClass) {
            subTypeChooser.setClass(typeClass, false);
        }
        
        private EIURI getSelectedType() {
            return subTypeChooser.getSelectedURI();
        }
    }
	
	interface Binder extends UiBinder<Widget, FilterPanel> {
    }

	private static final Binder binder = GWT.create(Binder.class);

	@UiField
	HorizontalPanel filterListPanel;
	
	private TypePropertyFilter typeFilter;
	private EIClass currentClass = null;
	
	public FilterPanel() {
		 initWidget(binder.createAndBindUi(this));
		 typeFilter = new TypePropertyFilter();
		 filterListPanel.add(typeFilter);
	}
	
    public void setResourceType(EIURI typeURI) {
        if (typeURI == null) {
            setResourceType((EIClass) null);
        } else {
            ClientModelManager.INSTANCE.getClass(typeURI, new ClassCallback() {
                
                @Override
                public void onSuccess(EIClass result) {
                    setResourceType(result);
                }
            });
        }
    }
    
	public void setResourceType(EIClass typeClass) {
	    if (currentClass != null && currentClass.equals(typeClass)) {
	        return;
	    }
	    if (typeClass == null) {
	        setVisible(false);
	    } else {
	        typeFilter.setClass(typeClass);
            setVisible(true);
	    }
	    currentClass = typeClass;
	}
	
	public void addFilters(SearchRequest request) {
	    if (currentClass != null) {
    	    EIURI selectedURI = typeFilter.getSelectedType();
    	    if (selectedURI != null) {
    	        request.setBinding(new TypeBinding(selectedURI));
    	    }
	    }
	}
	
}
