package org.eaglei.ui.gwt.search.results;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style.Visibility;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;

/**
 * A simple widget representing prev/next page navigation.
 */
class NavBar extends Composite {
    @UiTemplate("NavBar.ui.xml")
    interface Binder extends UiBinder<Widget, NavBar> {
    }

    private static final Binder binder = GWT.create(Binder.class);

    @UiField
    Element countLabel;
    @UiField
    Anchor previousButton;
    @UiField
    Anchor nextButton;

    private final ResourcesGrid outer;

    public NavBar(ResourcesGrid outer) {
        initWidget(binder.createAndBindUi(this));
        this.outer = outer;
        previousButton.addMouseOverHandler(new MouseOverHandler() {
            
            @Override
            public void onMouseOver(MouseOverEvent event) {
                previousButton.addStyleDependentName("hovering");
            }
        });
        previousButton.addMouseOutHandler(new MouseOutHandler() {
            
            @Override
            public void onMouseOut(MouseOutEvent event) {
                previousButton.removeStyleDependentName("hovering");
            }
        });
        nextButton.addMouseOverHandler(new MouseOverHandler() {
            
            @Override
            public void onMouseOver(MouseOverEvent event) {
                nextButton.addStyleDependentName("hovering");
            }
        });
        nextButton.addMouseOutHandler(new MouseOutHandler() {
            
            @Override
            public void onMouseOut(MouseOutEvent event) {
                nextButton.removeStyleDependentName("hovering");
            }
        });
    }

    public void update(int startIndex, int count, int max) {
        setVisibility(previousButton, startIndex != 0);
        setVisibility(nextButton, startIndex + ResultsListPanel.VISIBLE_RESULT_COUNT < count);
        countLabel.setInnerText("" + (startIndex + 1) + " - " + max + " of " + count);
    }

    @UiHandler("previousButton")
    void onNewerClicked(ClickEvent event) {
        outer.previousPage();
    }

    @UiHandler("nextButton")
    void onOlderClicked(ClickEvent event) {
        outer.nextPage();
    }

    private void setVisibility(Widget widget, boolean visible) {
        widget.setVisible(visible);
        //widget.getElement().getStyle().setVisibility(
        //        visible ? Visibility.VISIBLE : Visibility.HIDDEN);
    }
}
