package org.eaglei.ui.gwt.search.results;

import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.search.SearchBar;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.SearchBar.SearchRequestListener;
import org.eaglei.ui.gwt.search.SearchContext.SearchListener;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.sidebar.LeftListPanel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.CssResource.NotStrict;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class ResultsPage extends Composite implements SearchListener {

    interface ResultsResources extends ClientBundle {
        @NotStrict
        @Source("results.css")
        CssResource css();
    }

    /*
    interface MyUiBinder extends UiBinder<SimplePanel, ResultsPage> {
    }

    private static MyUiBinder uiBinder = GWT.create(MyUiBinder.class);

    @UiField
    ResultsTabPanel tabPanel;
    @UiField
    SideBar sideBar;
    */
	private LeftListPanel		listPanel;
	private VerticalPanel		dataPanel;
	private FilterPanel filterPanel;
	private SearchBar searchBar;
	private ResourcesGrid resultsGrid;

    public ResultsPage() {
    	/*
        // Inject styles.
        GWT.<ResultsResources> create(ResultsResources.class).css().ensureInjected();
        initWidget(uiBinder.createAndBindUi(this));
        DOM.getParent(tabPanel.getElement()).getStyle().setProperty("width", "100%");
        */
    	HorizontalPanel outer = new HorizontalPanel();
		listPanel = new LeftListPanel();
		outer.add(listPanel);
		dataPanel = new VerticalPanel();
		dataPanel.setStyleName("dataPanel");
		outer.add(dataPanel);
		initWidget(outer);
		
        searchBar = new SearchBar(false);
        dataPanel.add(searchBar);
        searchBar.sizeToParent(735);
        filterPanel = new FilterPanel();
        dataPanel.add(filterPanel);
        resultsGrid = new ResourcesGrid();
        dataPanel.add(resultsGrid);
        
        searchBar.addSearchRequestListener(new SearchRequestListener() {

            @Override
            public void onRequest(SearchRequest request) {
                filterPanel.addFilters(request);
                SearchContext.INSTANCE.search(request, false);
            }

        });
        
        if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            displaySearchRequest(SearchContext.INSTANCE.getCurrentRequest());
            if (SearchContext.INSTANCE.isPending()) {
                resultsGrid.displaySearchPending();
            } else {
                resultsGrid.displaySearchResults(SearchContext.INSTANCE.getCurrentResults());
            }
        }
        SearchContext.INSTANCE.addListener(this);
    }
	
    /**
     * Handles parsing of params supported by the results page.
     * 
     * @param params
     */
    public void setPageParams(String params) {
        SearchRequest request = new SearchRequest(params);
        SearchContext.INSTANCE.search(request, false);
    }
    
    @Override
    public void onFailure(SearchRequest request, String message) {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void onRequest(SearchRequest request, boolean isPageRequest) {
        displaySearchRequest(request);
        resultsGrid.displaySearchPending();
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        displaySearchRequest(results.getResultSet().getRequest());
        resultsGrid.displaySearchResults(results);
    }
    
    private void displaySearchRequest(SearchRequest request) {
        searchBar.setSearchRequest(request);
        EIURI typeURI = (request != null && request.getBinding() != null) ? request.getBinding().getType() : null;
        filterPanel.setResourceType(typeURI);
    }

}
