package org.eaglei.ui.gwt.security;

import java.util.ArrayList;

import org.eaglei.ui.gwt.security.rpc.SecurityServiceRemote;
import org.eaglei.ui.gwt.security.rpc.SecurityServiceRemoteAsync;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class SessionContext {
	
	public interface SessionListener {
		void onLogIn(Session session);
		void onLogOut();
	}

    private static final SecurityServiceRemoteAsync securityService = GWT.create(SecurityServiceRemote.class);
	public static final SessionContext INSTANCE = new SessionContext();
	
	/**
	 * Convenience method for getting the session id.
	 * Will return null if the session is currently null.
	 * 
	 * @return session id string, null if session is null
	 */
	public static String getSessionId() {
		return INSTANCE.getSession() != null ? INSTANCE.getSession().getSessionId() : null;
	}
	
	private String pendingUser = null;
	private Session current = null;
	private ArrayList<SessionListener> listeners = new ArrayList<SessionListener>();
	
	private SessionContext() {
		
	}
	
	public Session getSession() {
		return current;
	}
	
	
	public void addListener(SessionListener listener) {
		listeners.add(listener);
	}
	
	public String getPendingUser() {
		return pendingUser;
	}

	public void logIn(String user, String password) {
		this.pendingUser = user;
        securityService.logIn(user, password, new AsyncCallback<Session>() {

            public void onFailure(Throwable caught) {
                Window.alert("Invalid login.  Please check username and password.");
            }

            public void onSuccess(Session result) {
                if (result == null) {
                    Window.alert("Invalid login.  Please check username and password.");
                    return;
                }
                setSession(result);
            }
            
        });
	}

	private void setSession(Session session) {
		if (pendingUser == null || !pendingUser.equals(session.getUserName())) {
			// Check that request has not been canceled,
			// or that a new request has not been submitted.
			return;
		}
		this.pendingUser = null;
		this.current = session;
		for (SessionListener listener : listeners) {
			listener.onLogIn(session);
		}
	}
	
	public void logOut() {
		this.pendingUser = null;
		for (SessionListener listener : listeners) {
			listener.onLogOut();
		}
		String sessionId = (current != null) ? current.getSessionId() : null;
		this.current = null;
        securityService.logOut(sessionId, new AsyncCallback<Void>() {

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Void result) {
            }
            
        });		
	}
}
