package org.eaglei.ui.gwt.search.results;

import java.util.ArrayList;
import java.util.List;

import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;

import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DeckPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TabBar;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class ResultsTabPanel extends Composite { //implements SessionListener {
    
    public static int SUMMARY_DECK_INDEX;
    //public static int TABLE_DECK_INDEX;
    //public static int MAP_DECK_INDEX;
    private static int STATUS_DECK_INDEX;
    
    private static class Tab extends SimplePanel {
        private boolean selected;

        Tab(String text) {
            setStyleName("ResultsTab");
            final Label l = new Label(text);
            l.addStyleName("label");
            setWidget(l);
            
            addDomHandler(new MouseOverHandler() {
                public void onMouseOver(MouseOverEvent event) {
                    if (!selected) {
                        addStyleDependentName("over");
                    }
                }
            }, MouseOverEvent.getType());
            addDomHandler(new MouseOutHandler() {
                public void onMouseOut(MouseOutEvent event) {
                    if (!selected) {
                        removeStyleDependentName("over");
                    }
                }
            }, MouseOutEvent.getType());
        }
        
        void setSelected(boolean selected) {
            this.selected = selected;
            if (selected) {
                removeStyleDependentName("over");
            }
        }
        
    }

    private final VerticalPanel outer = new VerticalPanel();
    private final TabBar tabBar = new TabBar();
    private final List<Tab> listTabs = new ArrayList<Tab>();
    private final DeckPanel deck = new DeckPanel();
    private final SimplePanel statusPanel = new SimplePanel();
    private final HorizontalPanel searchingPanel = new HorizontalPanel();
    
    private ResultsListPanel panelSummary;
    //private ResultsTablePanel panelTable;
    //private ResultsMapPanel panelMap;
    
    private SearchRequest request; 
    private SearchResultSet results;
    
    public ResultsTabPanel() {
        initWidget(outer);

        outer.add(tabBar);
        tabBar.setStyleName("ResultsTabBar");
        // Tab bar is not currently being used
        tabBar.setVisible(false);
        
        outer.add(deck);
        deck.setWidth("100%");
        deck.setHeight("100%");
        
        Tab tab;
        SimplePanel panelWrapper;
        
        // Summary
        panelWrapper = new SimplePanel();
        deck.add(panelWrapper);
        tab = new Tab("List") {
            @Override
            void setSelected(boolean selected) {
                super.setSelected(selected);
                if (selected) {
                    displaySummary();
                }
            }
        };
        SUMMARY_DECK_INDEX = tabBar.getTabCount();
        tabBar.addTab(tab);
        listTabs.add(tab);
        
        // Table
        /*
        panelWrapper = new SimplePanel();
        deck.add(panelWrapper);
        tab = new Tab("Table") {
            @Override
            void setSelected(boolean selected) {
                super.setSelected(selected);
                if (selected) {
                    displayTable();
                    deck.showWidget(TABLE_DECK_INDEX);
                }
            }
        };
        TABLE_DECK_INDEX = tabBar.getTabCount();
        tabBar.addTab(tab);
        listTabs.add(tab);
        */
        
        // Map
        /*
        panelWrapper = new SimplePanel();
        deck.add(panelWrapper);
        tab = new Tab("Map") {
            @Override
            void setSelected(boolean selected) {
                super.setSelected(selected);
                if (selected) {
                    displayMap();
                    deck.showWidget(MAP_DECK_INDEX);
                }
            }
        };
        MAP_DECK_INDEX = tabBar.getTabCount();
        tabBar.addTab(tab);
        listTabs.add(tab);
        */
        
        // Status deck panel
        statusPanel.setStyleName("ResultsLoadingPanel");
        deck.add(statusPanel);
        STATUS_DECK_INDEX = tabBar.getTabCount();
        
        tabBar.addBeforeSelectionHandler(new BeforeSelectionHandler<Integer>() {
            public void onBeforeSelection(BeforeSelectionEvent<Integer> event) {
                int selectIndex = tabBar.getSelectedTab();
                if (selectIndex < 0 || selectIndex >= tabBar.getTabCount()) {
                    return;
                }
                listTabs.get(selectIndex).setSelected(false);
            }
        });
        tabBar.addSelectionHandler(new SelectionHandler<Integer>() {
            public void onSelection(SelectionEvent<Integer> event) {
                int selectIndex = tabBar.getSelectedTab();
                if (selectIndex < 0 || selectIndex >= tabBar.getTabCount()) {
                    return;
                }
                listTabs.get(selectIndex).setSelected(true);
            }
        });
        
        //ClientSearchManager.INSTANCE.addSessionListener(this);
        
        selectTab(SUMMARY_DECK_INDEX);
    }
    
    public void selectTab(int index) {
        tabBar.selectTab(index);
    }
    
    public void setLoggedOut() {
        statusPanel.setWidget(new Label("You must be signed in to see search results."));
        deck.showWidget(STATUS_DECK_INDEX);
    }
    
    public void setNoResults() {
        statusPanel.setWidget(new Label("No resources found."));
        deck.showWidget(STATUS_DECK_INDEX);
    }
    
    private void setSearching() {
        if (searchingPanel.getWidgetCount() == 0) {
            //searchingPanel.add(ApplicationImages.LOADING);
            searchingPanel.add(new Label("Searching..."));
        }
        statusPanel.setWidget(searchingPanel);
        deck.showWidget(STATUS_DECK_INDEX);
    }
    
    public void setSearchRequest(SearchRequest request) {
        this.request = request;
        setSearching();
        /*
        ClientSearchManager.INSTANCE.getResults(request, new ResultsCallback() {

            @Override
            public void onSuccess(SearchResultSet result) {
                setResults(result);
            }

            @Override
            public void loginRequired() {
                setLoggedOut();
            }
        });  
        */      
    }

    private void setResults(SearchResultSet results) {
        this.results = results;
        if (results == null || results.getTotalCount() == 0) {
            setNoResults();
        } else {
            if (tabBar.getSelectedTab() == SUMMARY_DECK_INDEX) {
                displaySummary();
            }
            
            /*
            case TABLE_DECK_INDEX:
                displayTable();
                break;
            case MAP_DECK_INDEX:
                displayMap();
                break;
            */
        }
    }
    
    private void displaySummary() {
        deck.showWidget(STATUS_DECK_INDEX);
        DeferredCommand.addCommand(new Command() {
            public void execute() {
                if (panelSummary == null) {
                    panelSummary = new ResultsListPanel();
                    ((SimplePanel) deck.getWidget(SUMMARY_DECK_INDEX)).setWidget(panelSummary);
                }
                if (results != null) {
                    panelSummary.setResultSet(results);
                    deck.showWidget(SUMMARY_DECK_INDEX);
                }
            }
        });
    }
    
    private void displayTable() {
        /*
        deck.showWidget(LOADING_DECK_INDEX);
        DeferredCommand.addCommand(new Command() {
            public void execute() {
                if (panelTable == null) {
                    panelTable = new ResultsTablePanel();
                    ((SimplePanel) deck.getWidget(TABLE_DECK_INDEX)).setWidget(panelTable);
                }
                panelTable.setData(rClass, results);
                deck.showWidget(TABLE_DECK_INDEX);
            }
        });
        */
    }
    
    private void displayMap() {
        /*
        deck.showWidget(LOADING_DECK_INDEX);
        DeferredCommand.addCommand(new Command() {
            public void execute() {
                if (panelMap == null) {
                    panelMap = new ResultsMapPanel();
                    ((SimplePanel) deck.getWidget(MAP_DECK_INDEX)).setWidget(panelMap);
                }
                panelMap.setData(rClass, results);
                deck.showWidget(MAP_DECK_INDEX);
            }
        });
        */
    }

    /*
    @Override
    public void onLogIn(String username) {
        // On login, automatically execute any current search request
        setSearchRequest(this.request);
    }

    @Override
    public void onLogOut() {
        // On logout, automatically execute any current search request, which may display
        // the not logged in page.
        setSearchRequest(this.request);
    }
    */
    
}
