package org.eaglei.ui.gwt.search.results;

import java.util.ArrayList;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.suggest.client.AbstractSearchBox;
import org.eaglei.suggest.client.EntitySelectionListener;
import org.eaglei.suggest.client.OntologyDropdownBase;
import org.eaglei.suggest.client.SearchSuggestOracle;
import org.eaglei.suggest.client.SearchSuggestion;
import org.eaglei.suggest.client.SelectionListener;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.SuggestOracle.Suggestion;

public class TypeChooser<OntologyPicker extends OntologyDropdownBase> extends Composite {
	private static class TypeSuggestOracle extends SearchSuggestOracle {
        private String classId;

        public TypeSuggestOracle() {
            super(GWT.getModuleBaseURL());
        }

        void setClassId(EIURI classId) {
            if (classId == null) {
                this.classId = null;
            } else {
                this.classId = URL.encodeComponent(classId.toString());
            }
        }

        protected String createURL(String callbackName, int id, String query) {
            String url = super.createURL(callbackName, id, query);
            return (classId != null) ? url + "&classid=" + classId : url;
        }
    }

    /**/

    /**/
    private static class TypeSuggestBox extends AbstractSearchBox {
        private EIClass rootClass;
        private EIEntity selectedEntity;
        private ArrayList<EntitySelectionListener> listeners = null;

        public TypeSuggestBox() {
            super(new TypeSuggestOracle(), "TypeSearchBox");
            sbSearch.getTextBox().addBlurHandler(new BlurHandler() {

                @Override
                public void onBlur(BlurEvent event) {
                    // TODO recognize entered text as matching a valid entity
                    if ((selectedEntity == null && ! getDefaultText().equals(sbSearch.getText()))
                            || (selectedEntity != null && ! selectedEntity.getLabel().equals(sbSearch.getText()))) {
                        setSelectedEntity(null);
                    }
                }
                
            });
        }
        
        public void setEnabled(boolean enabled){
        	sbSearch.getTextBox().setEnabled(enabled);
        }
        
        public void addSelectionListener(EntitySelectionListener listener)
        {
        	if (listeners == null)
        	{
        		listeners = new ArrayList<EntitySelectionListener>();
        	}
        	listeners.add(listener);
        }

        @Override
        public String getDefaultText() {
            return rootClass != null ? rootClass.getEntity().getLabel() : "All Resource Types";
        }

        @Override
        public String getSearchBaseURL() {
            assert (false);
            return null;
        }

        public void setClass(EIClass rootClass) {
        	this.rootClass = rootClass;
            EIURI uri = (rootClass != null) ? rootClass.getEntity().getURI() : null;
            ((TypeSuggestOracle) sbSearch.getSuggestOracle()).setClassId(uri);
            
            // Initialize selection to the root class
            setSelectedEntity((rootClass != null) ? rootClass.getEntity() : null);
        }

        public EIEntity getSelectedEntity() {
            return selectedEntity;
        }

        public void setSelectedEntity(EIEntity selectedEntity) {
        	this.selectedEntity = selectedEntity; 
        	if (selectedEntity != null) {
        	    setText(selectedEntity.getLabel());
        	} else {
        	    setDefaultText();
        	}
            // Could add check to only notify on change.
        	// But note that the display text in the box may still need to be
        	// refreshed, even if there is no change.
            if (listeners != null)
            {
	            for (EntitySelectionListener listener : listeners)
	            {
	            	listener.onSelection(selectedEntity); 
	            }
            }
        }
        
        
    }

    /**/

    private TypeSuggestBox boxType;
    private OntologyPicker ontologyBrowser;
    
    
    public TypeChooser(OntologyPicker ontPicker) {
    	HorizontalPanel hp = new HorizontalPanel();
        hp.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        initWidget(hp);

        boxType = new TypeSuggestBox();
        boxType.addSelectionHandler(new SelectionHandler<Suggestion>() {
            public void onSelection(SelectionEvent<Suggestion> event) {
                SearchSuggestion suggestion = (SearchSuggestion) event.getSelectedItem();
                // This is a bit sketchy as the suggest list display string
                // may not technically match the preferred entity label.
                EIEntity selectedEntity = 
                    EIEntity.create(suggestion.getURIString(), removeTags(suggestion.getDisplayString()));
                boxType.setSelectedEntity(selectedEntity);
            }
        });
        hp.add(boxType);
 
        ontologyBrowser = ontPicker;
        ontologyBrowser.addSelectionListener(new SelectionListener() {

            public void onSelection(EIClass resource) {
                boxType.setSelectedEntity(resource.getEntity());
            }

        });
        hp.add(ontologyBrowser);
    }
    
    public void addSelectionListener(EntitySelectionListener listener)
    {
    	this.boxType.addSelectionListener(listener);
    }
    
    // TODO: test me!
    protected String removeTags(String displayString) {
		String result = displayString.replace("<B>", "");
		result = result.replace("</B>", "");
				
		return result;
	}

    public void setClass(EIClass rClass, boolean readOnly) {
        boxType.setClass(rClass);
        // if (readOnly) {
        // boxType.setText(rClass.getEntity().getLabel());
        // }
        // boxType.setReadOnly(readOnly);
        if (rClass != null && rClass.hasSubClass()) {
            ontologyBrowser.setResource(rClass);
            ontologyBrowser.setVisible(true);
        } else {
            ontologyBrowser.setVisible(false);
        }
    }

    public EIURI getSelectedURI() {
        return (boxType.getSelectedEntity() != null) ? boxType.getSelectedEntity().getURI() : null;
    }
    
    public void setSelectedEntity(EIEntity selectedEntity) { 
        boxType.setSelectedEntity(selectedEntity);
    }
    
    public void setTextBoxStyle(String styleName)
    {
    	boxType.setStyleName(styleName);
    }
    
    public void setEnabled(boolean enabled) {
        boxType.setEnabled(enabled);
        ontologyBrowser.setVisible(enabled);
    }
}
