package org.eaglei.ui.gwt.search.rpc;

import java.io.Serializable;
import java.util.HashMap;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchResultSet;

public class ClientSearchResultSet implements Serializable {
    
    private SearchResultSet resultSet;
    // Entity of the type binding
    private EIEntity bindingEntity;
    // The URI of the category that the type binding belongs to
    private EIURI bindingCategoryURI;
    // Lookup table of the top-level types for search result types in the result set.
    private HashMap<EIURI, EIEntity> mapURIToRootEntity;
    
    private ClientSearchResultSet() {
        // for gwt
    }
    
    public ClientSearchResultSet(SearchResultSet resultSet, EIEntity bindingEntity, 
            EIURI bindingCategoryURI, HashMap<EIURI, EIEntity> mapURIToRootEntity) {
        this.resultSet = resultSet;
        this.bindingEntity = bindingEntity;
        this.bindingCategoryURI = bindingCategoryURI;
        this.mapURIToRootEntity = mapURIToRootEntity;
    }
    
    public SearchResultSet getResultSet() {
        return resultSet;
    }

    public EIEntity getBindingEntity() {
        return bindingEntity;
    }

    public EIURI getBindingCategoryURI() {
        return bindingCategoryURI;
    }

    public HashMap<EIURI, EIEntity> getMapURIToRootEntity() {
        return mapURIToRootEntity;
    }

}
