/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results;

import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.model.EIEntity;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.results.NavBar;

public class ResultsListPanel
extends Composite {
    static final int VISIBLE_RESULT_COUNT = 10;
    private VerticalPanel panelResults = new VerticalPanel();
    private SearchResultSet results;
    private NavBar navBar;

    public ResultsListPanel() {
        this.panelResults.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        this.panelResults.add((Widget)this.navBar);
        this.panelResults.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        this.initWidget((Widget)this.panelResults);
        this.setWidth("100%");
    }

    void setResultSet(SearchResultSet results) {
        if (this.results == results) {
            return;
        }
        this.results = results;
        int count = results.getTotalCount();
        int max = results.getStartIndex() + 10;
        if (max > count) {
            max = count;
        }
        this.navBar.update(results.getStartIndex(), count, max);
        for (int i = this.panelResults.getWidgetCount() - 1; i > 0; --i) {
            this.panelResults.remove(i);
        }
        for (SearchResult result : results.getResults()) {
            this.panelResults.add((Widget)new ResultPanel(result));
        }
    }

    void previousPage() {
        int startIndex = this.results.getStartIndex() - 10;
        assert (startIndex >= 0) : "paged beyond the start of the result list";
        this.executeNewSearch(startIndex);
    }

    void nextPage() {
        int startIndex = this.results.getStartIndex() + 10;
        assert (startIndex < this.results.getTotalCount()) : "paged beyond the end of the result list";
        this.executeNewSearch(startIndex);
    }

    private void executeNewSearch(int startIndex) {
        SearchRequest newRequest = new SearchRequest();
        SearchRequest oldRequest = this.results.getRequest();
        newRequest.setInstitution(oldRequest.getInstitution());
        newRequest.setTerm(oldRequest.getTerm());
        newRequest.setBinding(oldRequest.getBinding());
        newRequest.setStartIndex(startIndex);
        SearchContext.INSTANCE.search(newRequest, false, true);
    }

    private class ResultPanel
    extends VerticalPanel {
        ResultPanel(SearchResult result) {
            String labName;
            EIEntity lab;
            Anchor link;
            this.setStyleName("ResultPanel");
            String entityLabel = result.getEntity().getLabel();
            if (result.getURL() != null) {
                link = new Anchor(entityLabel, false, result.getURL());
                link.setTarget("_blank");
            } else {
                link = new Anchor(entityLabel);
            }
            link.addStyleName("link");
            this.add((Widget)link);
            String typeLabel = result.getType().getLabel();
            if (!typeLabel.equals(entityLabel)) {
                Label type = new Label(typeLabel);
                type.setStyleName("type");
                this.add((Widget)type);
            }
            if ((lab = result.getLab()) != null && !(labName = lab.getLabel()).equals(entityLabel)) {
                Label labLabel = new Label(labName);
                labLabel.setStyleName("location");
                this.add((Widget)labLabel);
            }
            Label institution = new Label(result.getInstitution().getLabel());
            institution.setStyleName("location");
            this.add((Widget)institution);
            if (result.getHighlight() != null) {
                HTML highlight = new HTML(result.getHighlight());
                highlight.setStyleName("snippit");
                this.add((Widget)highlight);
            }
        }
    }
}

