/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results;

import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.search.SearchBar;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.results.FilterPanel;
import org.eaglei.ui.gwt.search.results.NavBar;
import org.eaglei.ui.gwt.search.results.ResourcesGrid;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.sidebar.LeftListPanel;

public class ResultsPage
extends Composite
implements SearchContext.SearchListener {
    private LeftListPanel listPanel;
    private VerticalPanel dataPanel;
    private FilterPanel filterPanel;
    private SearchBar searchBar;
    private ResourcesGrid resultsGrid;

    public ResultsPage() {
        HorizontalPanel outer = new HorizontalPanel();
        this.listPanel = new LeftListPanel();
        outer.add((Widget)this.listPanel);
        this.dataPanel = new VerticalPanel();
        this.dataPanel.setStyleName("dataPanel");
        outer.add((Widget)this.dataPanel);
        this.initWidget((Widget)outer);
        this.searchBar = new SearchBar(false);
        this.dataPanel.add((Widget)this.searchBar);
        this.searchBar.sizeToParent(735);
        this.filterPanel = new FilterPanel();
        this.dataPanel.add((Widget)this.filterPanel);
        NavBar navBar = new NavBar();
        this.dataPanel.add((Widget)navBar);
        this.resultsGrid = new ResourcesGrid(navBar);
        this.dataPanel.add((Widget)this.resultsGrid);
        this.searchBar.addSearchRequestListener(new SearchBar.SearchRequestListener(){

            @Override
            public void onRequest(SearchRequest request) {
                ResultsPage.this.filterPanel.addFilters(request);
                SearchContext.INSTANCE.search(request, false, false);
            }
        });
        if (SearchContext.INSTANCE.getCurrentResults() != null) {
            this.onResults(SearchContext.INSTANCE.getCurrentResults());
        } else if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            this.onRequest(SearchContext.INSTANCE.getCurrentRequest(), true, false);
        }
        SearchContext.INSTANCE.addListener(this);
    }

    public void setPageParams(String params) {
        SearchRequest request = new SearchRequest(params);
        SearchContext.INSTANCE.search(request);
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
        this.resultsGrid.displayStatusMessage(message);
    }

    @Override
    public void onRequest(SearchRequest request, boolean isTypeCategoryChange, boolean isPageRequest) {
        this.searchBar.setSearchRequest(request);
        if (isTypeCategoryChange) {
            EIURI typeCategoryURI = request != null && request.getBinding() != null ? request.getBinding().getType() : null;
            this.filterPanel.setResourceType(typeCategoryURI, null);
        }
        if (request == null) {
            this.resultsGrid.displayStatusMessage("");
        } else {
            this.resultsGrid.displaySearchPending();
        }
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        SearchRequest request = results.getResultSet().getRequest();
        this.searchBar.setSearchRequest(request);
        this.filterPanel.setResourceType(results.getBindingCategoryURI(), results.getBindingEntity());
        this.resultsGrid.displaySearchResults(results);
    }

    static interface ResultsResources
    extends ClientBundle {
        @CssResource.NotStrict
        @ClientBundle.Source(value={"results.css"})
        public CssResource css();
    }
}

