/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.security;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import org.eaglei.ui.gwt.security.Session;
import org.eaglei.ui.gwt.security.rpc.SecurityServiceRemote;
import org.eaglei.ui.gwt.security.rpc.SecurityServiceRemoteAsync;

public class SessionContext {
    private static final SecurityServiceRemoteAsync securityService = (SecurityServiceRemoteAsync)GWT.create(SecurityServiceRemote.class);
    public static final SessionContext INSTANCE = new SessionContext();
    public static final String EAGLEI_SESSION_ID = "eaglei_session";
    public static final String EAGLEI_USER_URI_ID = "eaglei_userUri";
    public static final String EAGLEI_USER_COOKIE_ID = "eaglei_username";
    public static final long DURATION = 1209600000L;
    private String pendingUser = null;
    private ArrayList<SessionListener> listeners = new ArrayList();

    public static boolean hasSession() {
        return Cookies.getCookieNames().contains(EAGLEI_SESSION_ID);
    }

    public static boolean hasUserUri() {
        return Cookies.getCookieNames().contains(EAGLEI_USER_URI_ID);
    }

    public static boolean hasUserName() {
        return Cookies.getCookieNames().contains(EAGLEI_USER_COOKIE_ID);
    }

    public static String getSessionId() {
        return SessionContext.hasSession() ? Cookies.getCookie((String)EAGLEI_SESSION_ID) : null;
    }

    public static String getUserUri() {
        return SessionContext.hasUserUri() ? Cookies.getCookie((String)EAGLEI_USER_URI_ID) : null;
    }

    public static String getUserName() {
        return SessionContext.hasUserName() ? Cookies.getCookie((String)EAGLEI_USER_COOKIE_ID) : null;
    }

    private static void setCookies(String username, String userUri, String sessionId) {
        Cookies.setCookie((String)EAGLEI_USER_COOKIE_ID, (String)username);
        Cookies.setCookie((String)EAGLEI_USER_URI_ID, (String)userUri);
        Cookies.setCookie((String)EAGLEI_SESSION_ID, (String)sessionId);
    }

    private static void removeCookies() {
        Cookies.removeCookie((String)EAGLEI_SESSION_ID);
        Cookies.removeCookie((String)EAGLEI_USER_COOKIE_ID);
        Cookies.removeCookie((String)EAGLEI_USER_URI_ID);
    }

    private SessionContext() {
    }

    public void addListener(SessionListener listener) {
        this.listeners.add(listener);
    }

    public String getPendingUser() {
        return this.pendingUser;
    }

    public void logIn(String user, String password) {
        this.pendingUser = user;
        securityService.logIn(user, password, new AsyncCallback<Session>(){

            public void onFailure(Throwable caught) {
                Window.alert((String)"Invalid login.  Please check username and password.");
            }

            public void onSuccess(Session result) {
                if (result == null) {
                    Window.alert((String)"Invalid login.  Please check username and password.");
                    return;
                }
                SessionContext.setCookies(result.getUserName(), result.getUserName(), result.getSessionId());
                for (SessionListener listener : SessionContext.this.listeners) {
                    listener.onLogIn();
                }
            }
        });
    }

    public void logOut() {
        this.pendingUser = null;
        for (SessionListener listener : this.listeners) {
            listener.onLogOut();
        }
        String sessionId = SessionContext.getSessionId();
        SessionContext.removeCookies();
        securityService.logOut(sessionId, new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Void result) {
            }
        });
    }

    public static interface SessionListener {
        public void onLogIn();

        public void onLogOut();
    }
}

