/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemoteAsync;
import org.eaglei.ui.gwt.security.SessionContext;

public class NewTopPanel
extends Composite
implements SessionContext.SessionListener {
    public static boolean HAS_INSTITUTION_SELECT;
    private static final Binder binder;
    Label welcomeLabel;
    Anchor logoutAnchor;
    UListElement loginList;
    ListBox institutionListBox;
    TextBox userTextBox;
    PasswordTextBox passTextBox;
    Button loginButton;
    @UiField
    Anchor helpLink;
    private List<EIEntity> listInstitutionEntities = null;
    boolean signedIn = false;
    public static String[] wfStates;
    public static Map<String, Boolean> accessMap;

    public NewTopPanel() {
        this(true);
    }

    private String getHelpUrl() {
        String url = GWT.getHostPageBaseURL();
        url = url.substring(0, url.length() - 1);
        url = url.substring(0, url.lastIndexOf(47));
        url = url + "/help/eagle-i.htm";
        return url;
    }

    public NewTopPanel(boolean requiresLogin) {
        this.initWidget((Widget)binder.createAndBindUi(this));
        this.helpLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                Window.open((String)NewTopPanel.this.getHelpUrl(), (String)"_blank", (String)("height=" + NewTopPanel.this.getHelpWindowHeight() + ",width=" + NewTopPanel.this.getHelpWindowWidth() + ",left=" + NewTopPanel.this.getHelpWindowLeft() + ",top=0"));
            }
        });
    }

    private void performLogin() {
        String user;
        String institutionId = null;
        if (HAS_INSTITUTION_SELECT) {
            EIURI institutionURI = this.listInstitutionEntities.get(this.institutionListBox.getSelectedIndex()).getURI();
            institutionId = institutionURI.toString();
        }
        if ((user = this.userTextBox.getText()) == null || user.trim().length() == 0) {
            Window.alert((String)"A username is required");
            return;
        }
        String pass = this.passTextBox.getText();
        if (pass == null || pass.trim().length() == 0) {
            Window.alert((String)"A password is required");
            return;
        }
        SessionContext.INSTANCE.logIn(institutionId, user.trim(), pass.trim());
    }

    private void performLogout() {
        SessionContext.INSTANCE.logOut();
    }

    @Override
    public void onLogOut() {
        this.welcomeLabel.setText("Please login");
        this.logoutAnchor.setVisible(false);
        if (HAS_INSTITUTION_SELECT) {
            this.institutionListBox.setVisible(true);
        }
        this.loginList.getStyle().setVisibility(Style.Visibility.VISIBLE);
        this.signedIn = false;
        this.userTextBox.setText("");
        this.passTextBox.setText("");
    }

    @Override
    public void onLogIn() {
        this.welcomeLabel.setText("Welcome, " + SessionContext.getUserName());
        this.logoutAnchor.setVisible(true);
        if (HAS_INSTITUTION_SELECT) {
            this.institutionListBox.setVisible(false);
        }
        this.loginList.getStyle().setVisibility(Style.Visibility.HIDDEN);
        this.signedIn = true;
    }

    private void initInstitutionList() {
        SearchServiceRemoteAsync searchService = (SearchServiceRemoteAsync)GWT.create(SearchServiceRemote.class);
        searchService.getInstitutions(new AsyncCallback<List<EIEntity>>(){

            public void onSuccess(List<EIEntity> result) {
                NewTopPanel.this.listInstitutionEntities = result;
                for (EIEntity institution : result) {
                    NewTopPanel.this.institutionListBox.addItem(institution.getLabel());
                }
            }

            public void onFailure(Throwable caught) {
            }
        });
    }

    private int getHelpWindowHeight() {
        return Window.getClientHeight() + Window.getClientHeight() / 12;
    }

    private int getHelpWindowWidth() {
        return 600;
    }

    private int getHelpWindowLeft() {
        return Window.getClientWidth() - this.getHelpWindowWidth();
    }

    static {
        binder = (Binder)GWT.create(Binder.class);
        accessMap = new HashMap<String, Boolean>();
    }

    static interface Binder
    extends UiBinder<Widget, NewTopPanel> {
    }
}

