/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.instance;

import com.google.gwt.user.client.ui.FlowPanel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;
import org.eaglei.ui.gwt.instance.Renderer;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

public abstract class OntologyPropertiesRenderer
implements Renderer {
    protected EIInstance eiInstance;
    protected EIClass eiClass;
    protected List<EIProperty> eiProperties;
    protected Map<EIEntity, EIProperty> eiPropertiesEntityMap = new HashMap<EIEntity, EIProperty>();
    protected FlowPanel ontologyPanel;
    protected EIClass rootSuperClass;

    public abstract Collection<EIEntity> getDataTypeEntities();

    public abstract Collection<EIEntity> getObjectTypeEntities();

    public abstract void addFormTitle(String var1);

    public abstract void fetchConstants();

    protected abstract void addNameProperty(String var1);

    protected abstract void addTypeProperty(String var1);

    public OntologyPropertiesRenderer(EIInstance eiInstance, FlowPanel ontologyPanel) {
        this.ontologyPanel = ontologyPanel;
        ontologyPanel.setStyleName("formPanelInside");
        this.eiInstance = eiInstance;
        this.eiClass = eiInstance.getInstanceClass();
        this.rootSuperClass = eiInstance.getRootSuperType();
        this.initializeProperties();
    }

    @Override
    public void renderProperties() {
        String labelPrefix = this.rootSuperClass != null ? this.rootSuperClass.getEntity().getLabel() : this.eiClass.getEntity().getLabel();
        this.addFormTitle(labelPrefix);
        this.addNameProperty(labelPrefix);
        this.addTypeProperty(labelPrefix);
        Collection<EIEntity> dataProps = this.getDataTypeEntities();
        Collection<EIEntity> objectProps = this.getObjectTypeEntities();
        Map instanceDataTypeProperties = this.eiInstance.getDatatypeProperties();
        Map instanceObjectProperties = this.eiInstance.getObjectProperties();
        List<EIProperty> reorderedProperties = this.reorderProperties(labelPrefix, instanceDataTypeProperties);
        for (EIProperty property : reorderedProperties) {
            if (property instanceof EIDatatypeProperty && dataProps.contains(property.getEntity())) {
                this.drawDataProperty(property.getEntity(), property.getDefinition(), property.getValueRestriction() != null, (Set)instanceDataTypeProperties.get(property.getEntity()));
                continue;
            }
            if (!(property instanceof EIObjectProperty) || !objectProps.contains(property.getEntity())) continue;
            this.drawObjectProperty(property.getEntity(), property.getDefinition(), property.getValueRestriction() != null, (Set)instanceObjectProperties.get(property.getEntity()));
        }
    }

    private List<EIProperty> reorderProperties(String labelPrefix, Map<EIEntity, Set<String>> instanceDataTypeProperties) {
        ArrayList<EIProperty> personProperties = new ArrayList<EIProperty>();
        ArrayList<EIProperty> contactProperties = new ArrayList<EIProperty>();
        ArrayList<EIProperty> providerProperties = new ArrayList<EIProperty>();
        ArrayList<EIProperty> dateProperties = new ArrayList<EIProperty>();
        ArrayList<EIProperty> primaryProperties = new ArrayList<EIProperty>();
        ArrayList<EIProperty> secondaryProperties = new ArrayList<EIProperty>();
        Collection<EIEntity> dataprops = this.getDataTypeEntities();
        for (EIProperty property : this.eiProperties) {
            if (property.getEntity().equals((Object)EagleIEntityConstants.RESOURCE_DESCRIPTION_ENTITY) && dataprops.contains(property.getEntity())) {
                EIEntity newDescriptionEntity = EIEntity.create((EIURI)EagleIEntityConstants.RESOURCE_DESCRIPTION_ENTITY.getURI(), (String)InstanceWidgetUtils.getExtendedPropertyLabel(labelPrefix, EagleIEntityConstants.RESOURCE_DESCRIPTION_ENTITY.getLabel()));
                this.drawDataProperty(newDescriptionEntity, property.getDefinition(), property.getValueRestriction() != null, instanceDataTypeProperties.get(property.getEntity()));
                continue;
            }
            if (property.getEntity().equals((Object)EagleIEntityConstants.SYNONYM_ENTITY) && dataprops.contains(property.getEntity())) {
                EIEntity newSynonymEntity = EIEntity.create((EIURI)EagleIEntityConstants.SYNONYM_ENTITY.getURI(), (String)InstanceWidgetUtils.getExtendedPropertyLabel(labelPrefix, EagleIEntityConstants.SYNONYM_ENTITY.getLabel()));
                this.drawDataProperty(newSynonymEntity, property.getDefinition(), property.getValueRestriction() != null, instanceDataTypeProperties.get(property.getEntity()));
                continue;
            }
            if (this.hasPersonRange(property)) {
                personProperties.add(property);
                continue;
            }
            if (property.getEntity().getLabel().contains("date")) {
                dateProperties.add(property);
                continue;
            }
            Set annotations = property.getAnnotations();
            if (annotations.contains("http://eagle-i.org/ont/app/1.0/PropertyGroup/relatedLab")) {
                providerProperties.add(property);
                continue;
            }
            if (annotations.contains("http://eagle-i.org/ont/app/1.0/PropertyGroup_ContactLocation") || annotations.contains("http://eagle-i.org/ont/app/1.0/PropertyGroup_EmailContact")) {
                contactProperties.add(property);
                continue;
            }
            if (annotations.contains("http://eagle-i.org/ont/app/1.0/PropertyGroup_PrimaryProperties")) {
                primaryProperties.add(property);
                continue;
            }
            secondaryProperties.add(property);
        }
        ArrayList<EIProperty> reorderedProperties = new ArrayList<EIProperty>();
        reorderedProperties.addAll(providerProperties);
        reorderedProperties.addAll(personProperties);
        reorderedProperties.addAll(contactProperties);
        Collections.reverse(dateProperties);
        reorderedProperties.addAll(dateProperties);
        reorderedProperties.addAll(primaryProperties);
        reorderedProperties.addAll(secondaryProperties);
        return reorderedProperties;
    }

    private boolean hasPersonRange(EIProperty property) {
        if (!(property instanceof EIObjectProperty)) {
            return false;
        }
        List ranges = ((EIObjectProperty)property).getRangeList();
        return ranges.size() == 1 && ((EIClass)ranges.get(0)).getEntity().getURI().equals((Object)EagleIEntityConstants.FOAF_PERSON_URI);
    }

    protected HashSet<String> makeSetFromSingle(String value) {
        return new HashSet<String>(Arrays.asList(value));
    }

    protected HashSet<EIURI> makeSetFromSingleURI(EIURI value) {
        return new HashSet<EIURI>(Arrays.asList(value));
    }

    protected HashSet<EIEntity> makeSetFromSingleEntity(EIEntity value) {
        return new HashSet<EIEntity>(Arrays.asList(value));
    }

    protected abstract void drawDataProperty(EIEntity var1, String var2, boolean var3, Set<String> var4);

    protected abstract void drawObjectProperty(EIEntity var1, String var2, boolean var3, Set<EIEntity> var4);

    protected void initializeProperties() {
        ClientModelManager.INSTANCE.getProperties(this.eiClass, new ClientModelManager.PropertyCallback(){

            public void onSuccess(EIClass result) {
                ClientModelManager.INSTANCE.getPropertyDefinitions(result.getProperties(), new ClientModelManager.PropertyDefinitionCallback(){

                    public void onSuccess(List<EIProperty> properties) {
                        OntologyPropertiesRenderer.this.eiProperties = properties;
                        for (EIProperty property : OntologyPropertiesRenderer.this.eiProperties) {
                            OntologyPropertiesRenderer.this.eiPropertiesEntityMap.put(property.getEntity(), property);
                        }
                        OntologyPropertiesRenderer.this.fetchConstants();
                    }
                });
            }
        });
    }

    protected void finishSetup() {
        this.renderProperties();
    }
}

