/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.instance;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.ui.gwt.instance.EIEmbeddedResourceViewWidgetSearch;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;
import org.eaglei.ui.gwt.instance.InstanceChangeListener;
import org.eaglei.ui.gwt.instance.OntologyPropertiesRenderer;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemoteAsync;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.LabelValuesWidget;
import org.eaglei.ui.gwt.instance.widgets.SearchLabelValuesWidget;

public class SearchOntologyPropViewRenderer
extends OntologyPropertiesRenderer {
    private final InstanceChangeListener listener;
    private static final Logger log = Logger.getLogger("SearchOntologyPropViewRenderer");
    public static final InstanceServiceRemoteAsync instanceService = (InstanceServiceRemoteAsync)GWT.create(InstanceServiceRemote.class);

    public SearchOntologyPropViewRenderer(EIInstance eiInstance, FlowPanel ontologyPanel, InstanceChangeListener listener) {
        super(eiInstance, ontologyPanel);
        this.listener = listener;
    }

    @Override
    protected void drawDataProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<String> propertyValues) {
        LabelValuesWidget widget = new LabelValuesWidget(propertyEntity, propertyDefinition, isRequired);
        this.ontologyPanel.add((Widget)widget);
        for (String value : propertyValues) {
            widget.add(this.handleReadOnlyTextProperty(value));
        }
    }

    @Override
    protected void drawObjectProperty(EIEntity propertyEntity, String propertyDefinition, boolean isRequired, Set<EIEntity> propertyValues) {
        if (this.eiInstance.isPropertyValueAnEmbeddedInstance(propertyEntity)) {
            for (EIEntity propertyValue : propertyValues) {
                if (this.isObjectValueToIgnore(propertyValue)) continue;
                EIEmbeddedResourceViewWidgetSearch embeddedWidget = new EIEmbeddedResourceViewWidgetSearch(this.eiInstance.getEmbeddedInstance(propertyValue), propertyEntity, propertyDefinition, this.listener);
                this.ontologyPanel.add((Widget)embeddedWidget);
            }
        } else {
            if (propertyValues.size() == 0) {
                return;
            }
            LabelValuesWidget widget = new LabelValuesWidget(propertyEntity, propertyDefinition, isRequired);
            boolean hadValue = false;
            for (final EIEntity propertyValue : propertyValues) {
                if (this.isObjectValueToIgnore(propertyValue)) continue;
                hadValue = true;
                String displayValue = this.eiInstance.isPropertyValueAStub(propertyEntity, propertyValue) ? "* " + propertyValue.getLabel() : propertyValue.getLabel();
                Anchor a = new Anchor(InstanceWidgetUtils.formatText(displayValue));
                if (this.eiInstance.isPropertyValueAStub(propertyEntity, propertyValue)) {
                    a.addStyleName("Stub");
                }
                widget.add((Widget)a);
                a.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent arg0) {
                        ClientModelManager.INSTANCE.isModelClassURI(propertyValue.getURI(), (AsyncCallback)new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                            }

                            public void onSuccess(Boolean result) {
                                if (result.booleanValue()) {
                                    Window.open((String)(InstanceWidgetUtils.getGlossaryURL() + "#t=" + propertyValue.getURI().toString()), (String)"", (String)"");
                                } else {
                                    log.fine("listener changing instance to " + propertyValue.getURI());
                                    SearchOntologyPropViewRenderer.this.listener.onInstanceChanged(propertyValue.getURI());
                                }
                            }
                        });
                    }
                });
                if (!hadValue) continue;
                this.ontologyPanel.add((Widget)widget);
            }
        }
    }

    private boolean isObjectValueToIgnore(EIEntity propertyValue) {
        return propertyValue == null || propertyValue == EIEntity.NULL_ENTITY || propertyValue.getLabel().equals(EIEntity.NULL_ENTITY.getLabel()) || propertyValue.getLabel().startsWith("http");
    }

    protected Widget handleReadOnlyTextProperty(String value) {
        if (value.startsWith("www") || value.startsWith("http")) {
            return new Anchor(InstanceWidgetUtils.formatText(value), InstanceWidgetUtils.formatText(value), "_blank");
        }
        HTML valueField = new HTML(InstanceWidgetUtils.formatText(InstanceWidgetUtils.insertBreaks(value)));
        valueField.setStyleName("formLabelValue");
        return valueField;
    }

    @Override
    public Collection<EIEntity> getDataTypeEntities() {
        return this.eiInstance.getDatatypeProperties().keySet();
    }

    @Override
    public Collection<EIEntity> getObjectTypeEntities() {
        return this.eiInstance.getObjectProperties().keySet();
    }

    @Override
    public void addFormTitle(String type) {
        if (this.eiInstance.isEmbeddedInstance()) {
            return;
        }
        HTML stubsMessage = null;
        if (this.eiInstance.hasStubs()) {
            stubsMessage = new HTML("* This resource links to unfinished resources.");
        } else if (this.eiInstance.isStub()) {
            stubsMessage = new HTML("This resource is unfinished. Please review and save.");
        }
        if (stubsMessage != null) {
            stubsMessage.setStyleName("StubMessage");
            this.ontologyPanel.add((Widget)stubsMessage);
        }
    }

    @Override
    public void fetchConstants() {
        if (this.eiInstance.hasEmbeddedInstances()) {
            ClientModelManager.INSTANCE.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_embedded_class", new ClientModelManager.ClassesInGroupCallback(){

                public void onSuccess(List<EIClass> result) {
                    SearchOntologyPropViewRenderer.this.finishSetup();
                }
            });
        } else {
            this.finishSetup();
        }
    }

    @Override
    protected void addNameProperty(String labelPrefix) {
        if (this.eiInstance.isEmbeddedInstance()) {
            EIEntity namePropEntity = EIEntity.create((EIURI)EagleIEntityConstants.RDFS_LABEL_ENTITY.getURI(), (String)InstanceWidgetUtils.getExtendedPropertyLabel(labelPrefix, EagleIEntityConstants.RDFS_LABEL_ENTITY.getLabel()));
            this.drawDataProperty(namePropEntity, "", true, this.makeSetFromSingle(this.eiInstance.getInstanceLabel()));
        } else {
            SearchLabelValuesWidget searchLabelWidget = new SearchLabelValuesWidget(this.ontologyPanel);
            searchLabelWidget.add(this.eiInstance.getInstanceLabel(), "instanceTitle");
        }
    }

    @Override
    protected void addTypeProperty(String labelPrefix) {
        if (this.eiInstance.isEmbeddedInstance()) {
            EIEntity typePropEntity = EIEntity.create((EIURI)EagleIEntityConstants.RDF_TYPE_ENTITY.getURI(), (String)InstanceWidgetUtils.getExtendedPropertyLabel(labelPrefix, EagleIEntityConstants.RDF_TYPE_ENTITY.getLabel()));
            this.drawObjectProperty(typePropEntity, "", true, this.makeSetFromSingleEntity(this.eiInstance.getInstanceType()));
        } else {
            SearchLabelValuesWidget searchLabelWidget = new SearchLabelValuesWidget(this.ontologyPanel);
            searchLabelWidget.add(this.eiInstance.getInstanceType().getLabel(), "instanceType");
        }
    }
}

