/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.ApplicationContext;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemoteAsync;
import org.eaglei.ui.gwt.security.SessionContext;

public class SearchContext
implements SessionContext.SessionListener {
    public static final SearchServiceRemoteAsync searchService = (SearchServiceRemoteAsync)GWT.create(SearchServiceRemote.class);
    public static final SearchContext INSTANCE = new SearchContext();
    private SearchRequest currentRequest = null;
    private ClientSearchResultSet currentResults = null;
    private ArrayList<SearchListener> listeners = new ArrayList();

    private SearchContext() {
        SessionContext.INSTANCE.addListener(this);
    }

    public void addListener(SearchListener listener) {
        this.listeners.add(listener);
    }

    public SearchRequest getCurrentRequest() {
        return this.currentRequest;
    }

    public ClientSearchResultSet getCurrentResults() {
        return this.currentResults;
    }

    public void setFromHistoryParams(String params) {
        final SearchRequest request = new SearchRequest(params);
        if (!this.isNewRequest(request)) {
            return;
        }
        SearchRequest previous = this.currentRequest;
        this.currentRequest = request;
        this.currentResults = null;
        boolean isPageRequest = request != null ? request.equals((Object)previous, true) : false;
        for (SearchListener listener : this.listeners) {
            listener.onRequestPending(request, isPageRequest);
        }
        searchService.search(SessionContext.getSessionId(), request, new AsyncCallback<ClientSearchResultSet>(){

            public void onFailure(Throwable caught) {
                if (caught instanceof InvalidSessionIdException) {
                    SessionContext.INSTANCE.logOut();
                    return;
                }
                if (SearchContext.this.currentRequest == null || !SearchContext.this.currentRequest.equals((Object)request)) {
                    return;
                }
                SearchContext.this.currentRequest = null;
                SearchContext.this.errorNotification(request, caught.getMessage());
            }

            public void onSuccess(ClientSearchResultSet results) {
                if (SearchContext.this.currentRequest == null || !SearchContext.this.currentRequest.equals((Object)results.getResultSet().getRequest())) {
                    return;
                }
                SearchContext.this.currentResults = results;
                for (SearchListener listener : SearchContext.this.listeners) {
                    listener.onResults(results);
                }
            }
        });
    }

    private boolean isNewRequest(SearchRequest request) {
        if (this.currentRequest == null && request != null) {
            return true;
        }
        return !this.currentRequest.equals((Object)request);
    }

    private void errorNotification(SearchRequest request, String message) {
        for (SearchListener listener : this.listeners) {
            listener.onFailure(request, message);
        }
    }

    public void search(SearchRequest request) {
        if (SessionContext.getSessionId() == null) {
            this.onLogOut();
            return;
        }
        if (request == null) {
            request = new SearchRequest();
        }
        for (SearchListener listener : this.listeners) {
            listener.onRequestCreate(request);
        }
        ApplicationContext.setHistory("results/", request.toURLParams());
    }

    @Override
    public void onLogIn() {
    }

    @Override
    public void onLogOut() {
        this.errorNotification(this.currentRequest, "Please login");
        this.currentRequest = null;
        this.currentResults = null;
    }

    public static interface SearchListener {
        public void onRequestCreate(SearchRequest var1);

        public void onRequestPending(SearchRequest var1, boolean var2);

        public void onResults(ClientSearchResultSet var1);

        public void onFailure(SearchRequest var1, String var2);
    }
}

