/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.security.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.security.SecurityProvider;
import org.eaglei.security.Session;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.rpc.LoggedException;
import org.eaglei.ui.gwt.security.rpc.SecurityServiceRemote;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SecurityServlet
extends RemoteServiceServlet
implements SecurityServiceRemote {
    private static final Log logger = LogFactory.getLog(SecurityServlet.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private SecurityProvider securityProvider;
    private InstitutionRegistry institutionRegistry;

    public void init() {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.securityProvider = (SecurityProvider)ctx.getBean("securityProvider", SecurityProvider.class);
        this.institutionRegistry = (InstitutionRegistry)ctx.getBean(InstitutionRegistry.class);
    }

    public void destroy() {
    }

    @Override
    public List<EIEntity> getInstitutions() throws LoggedException, InvalidSessionIdException {
        try {
            return this.institutionRegistry.getInstitutions();
        }
        catch (Throwable t) {
            logger.error((Object)"Error in getInstitutions", t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }

    @Override
    public Session logIn(String institutionId, String username, String password) throws LoggedException {
        try {
            return this.securityProvider.logIn(institutionId, username, password);
        }
        catch (Throwable t) {
            logger.error((Object)"Error in login", t);
            throw new LoggedException(t.getLocalizedMessage());
        }
    }

    @Override
    public void logOut(String sessionId) {
        try {
            this.securityProvider.logOut(sessionId);
        }
        catch (Throwable t) {
            logger.error((Object)"Error in logout", t);
        }
    }

    @Override
    public Session getSession(String sessionId) {
        try {
            return this.securityProvider.getSession(sessionId);
        }
        catch (Throwable t) {
            logger.error((Object)"Error in getSession", t);
            return null;
        }
    }
}

