package org.eaglei.ui.gwt;

import java.util.List;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemoteAsync;
import org.eaglei.ui.gwt.security.SessionContext;
import org.eaglei.ui.gwt.security.SessionContext.SessionListener;
import org.eaglei.ui.gwt.security.rpc.SecurityServiceRemote;
import org.eaglei.ui.gwt.security.rpc.SecurityServiceRemoteAsync;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

public class LoginPanel extends Composite implements SessionListener {

    interface Binder extends UiBinder<Widget, LoginPanel> {
    }

    private static final Binder binder = GWT.create(Binder.class);

    @UiField
    public HTMLPanel loginBox;
    @UiField
    public HTMLPanel loginGrayOut;
    @UiField
    ListBox loginInstitutionList;
    @UiField
    TextBox loginUserText;
    @UiField
    PasswordTextBox loginPasswordText;
    @UiField
    Button loginButton;

    // Static list of institutions
    private List<EIEntity> listInstitutionEntities = null;

    public LoginPanel() {
        initWidget(binder.createAndBindUi(this));

        if (ApplicationContext.IS_INSTITUTION) {
            loginInstitutionList.setVisible(false);
        } else {
            initInstitutionList();
        }
        
        Image loginImage = new Image(ApplicationResources.INSTANCE.loginButton());
        loginImage.setWidth("104");
        loginImage.setHeight("32");
//        loginButton.getUpFace().setImage(loginImage);
        
        loginUserText.addFocusHandler(new FocusHandler() {
            public void onFocus(FocusEvent event) {
                if (getDefaultUsernameText().equals(loginUserText.getText())) {
                    loginUserText.setText("");
                }
            }
        });

        loginPasswordText.addKeyUpHandler(new KeyUpHandler() {
            @Override
            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
                    performLogin();
                }
            }
        });
        
        loginButton.addClickHandler(new ClickHandler() {
            
            @Override
            public void onClick(ClickEvent event) {
                performLogin();
            }
        });
        
        /*
        logoutAnchor.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                if (signedIn) {
                   performLogout();
                }
            }
        });
        */
        
        SessionContext.INSTANCE.addListener(this);
        // Initialize
        if (SessionContext.getSessionId() != null) {
            onLogIn();
        } else {
            onLogOut();
        }
        
    }

    private void initInstitutionList() {
        SecurityServiceRemoteAsync securityService = GWT.create(SecurityServiceRemote.class);
        securityService.getInstitutions(new AsyncCallback<List<EIEntity>>() {
            
            @Override
            public void onSuccess(List<EIEntity> result) {
                listInstitutionEntities = result;
                for (EIEntity institution : result) {
                    loginInstitutionList.addItem(institution.getLabel());
                }
            }
            
            @Override
            public void onFailure(Throwable caught) {
            }
        });
    }

    //------  Authentication methods --------------------------
    
    private void performLogin() {
        String institutionId = null;
        if (! ApplicationContext.IS_INSTITUTION) {
            EIURI institutionURI = listInstitutionEntities.get(loginInstitutionList.getSelectedIndex()).getURI();
            institutionId = institutionURI.toString();
        }
        
        String user = loginUserText.getText();
        if (user == null || user.trim().length() == 0) {
            Window.alert("A username is required");
            return;
        } 
        String pass = loginPasswordText.getText();
        if (pass == null || pass.trim().length() == 0) {
            Window.alert("A password is required");
            return;
        }
        SessionContext.INSTANCE.logIn(institutionId, user.trim(), pass.trim());
    }
    
    private void performLogout() {
        SessionContext.INSTANCE.logOut();
    }

    @Override
    public void onLogOut() {
        loginUserText.setText(getDefaultUsernameText());
        loginPasswordText.setText("");
    }
    
    private String getDefaultUsernameText() {
        return "Username";
    }

    @Override
    public void onLogIn() {
    }

}
