/**
 * 
 */
package org.eaglei.ui.gwt.search.results.grid;

import org.eaglei.ui.gwt.ApplicationResources;

import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author "Sravan Cheriyala" 
 * Started Mar 16, 2011
 */
public class EagleIGridRow extends GridRow {

	private final int CONTENT_SIZE=6;
	
	private final int RESOURCE_CLASS_INDEX = 2;
	private final int RESOURCE_TYPE_INDEX = 3;
	private final int RESOURCE_INSTITUTION_INDEX = 4;
	private final int RESOURCE_LAB_INDEX = 5;

	private int[] displayOrder= { RESOURCE_NAME_INDEX, 
	           					  RESOURCE_SNIPPIT_INDEX, 
	           					  RESOURCE_CLASS_INDEX, 
	           					  RESOURCE_TYPE_INDEX, 
	           					  RESOURCE_INSTITUTION_INDEX, 
	           					  RESOURCE_LAB_INDEX };

	private Widget resourceClassWidget;
	private Widget resourceTypeWidget;
	private Widget resourceInstitutionWidget;
	private Widget resourceLabWidget;

	public static final GridRow STATUS_ROW = new EagleIGridRow( new Widget[] { new Label() } );
	public static final GridRow PROGRESS_ROW = new EagleIGridRow( new Widget[] { new Image( ApplicationResources.INSTANCE.loading() ) } );
	public static final GridRow FIRST_RESULT_ROW = new EagleIGridRow();

	public EagleIGridRow(Widget[] widgets) {
		rowContentWidgets = widgets;
		setContent( rowContentWidgets ,displayOrder);
	}

	public EagleIGridRow() {
		rowContentWidgets=new Widget[CONTENT_SIZE];
	}

	


	public void setResourceClassWidget(Widget resourceClassWidget) {
		this.resourceClassWidget = resourceClassWidget;
		updateRowContent( resourceClassWidget, RESOURCE_CLASS_INDEX );
	}

	public void setResourceTypeWidget(Widget resourceTypeWidget) {
		this.resourceTypeWidget = resourceTypeWidget;
		updateRowContent( resourceTypeWidget, RESOURCE_TYPE_INDEX );
	}

	public void setResourceInstitutionWidget(Widget resourceInstitutionWidget) {
		this.resourceInstitutionWidget = resourceInstitutionWidget;
		updateRowContent( resourceInstitutionWidget,RESOURCE_INSTITUTION_INDEX );
	}

	public void setResourceLabWidget(Widget resourceLabWidget) {
		this.resourceLabWidget = resourceLabWidget;
		updateRowContent( resourceLabWidget, RESOURCE_LAB_INDEX );
	}

	
	protected int[] getDisplayOrder() {
		
		return displayOrder;
	}

	

}
