/**
 * 
 */
package org.eaglei.ui.gwt.search.results.renderers;

import java.util.Set;

import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchRequest.DataSet;
import org.eaglei.ui.gwt.search.results.grid.NIFGridRow;
import org.eaglei.ui.gwt.search.results.grid.ResourcesGrid;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author "Sravan Cheriyala" 
 * Started Mar 16, 2011
 */
public class NIFDataSetRenderer extends DataSetRenderer {

	private static final EIURI REPOSITORY_URI = EIURI.create( "repository" );

	public NIFDataSetRenderer(ResourcesGrid resultsTable, DataSet dataset) {
		this.resultsTable = resultsTable;
		this.dataset = dataset;
	}

	@Override
	public void createInstanceRow(int row, DataSet dataset, SearchResult searchResult) {
		int col = 0;

		// Name cell
		Widget instanceLink = getResourceNameLink( searchResult );
		HTML snippit = (HTML)getSnippit( searchResult );
		// Type cell
		Label typeLabel = new Label( searchResult.getType().getLabel() );

		// Location cell
		Set<String> repoList = searchResult.getDataTypeProperty( REPOSITORY_URI );
		FlowPanel locationPanel = makeLabelFromSet( repoList );

		NIFGridRow gridRow = new NIFGridRow();
		gridRow.setResourceNameWidget( instanceLink );
		gridRow.setResourceSnippitWidget( snippit );
		gridRow.setResourceTypeWidget( typeLabel );
		gridRow.setResourceLocationWidget( locationPanel );
		resultsTable.addRow( gridRow );

	}

	@Override
	protected Widget getResourceNameLink(SearchResult searchResult) {
		return new HTML( searchResult.getURL() );
	}

}
