package org.eaglei.ui.gwt.security.server;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.security.Session;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.repository.SecurityProvider;
import org.eaglei.ui.gwt.rpc.InvalidSessionIdException;
import org.eaglei.ui.gwt.rpc.LoggedException;
import org.eaglei.ui.gwt.security.rpc.SecurityServiceRemote;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * Implementation of SecurityService.
 */
public class SecurityServlet extends RemoteServiceServlet implements SecurityServiceRemote {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private static final Log logger = LogFactory.getLog(SecurityServlet.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    
    private SecurityProvider securityProvider;
    private InstitutionRegistry institutionRegistry;

    public SecurityServlet() {
    }

    @Override
    public void init() {
        WebApplicationContext ctx = 
            WebApplicationContextUtils.getWebApplicationContext(getServletContext());
        securityProvider = ctx.getBean("securityProvider", SecurityProvider.class);
        institutionRegistry = ctx.getBean(InstitutionRegistry.class);
    }

    @Override
    public void destroy() {
        // TODO does Spring need to be gracefully shutdown?
    }

    @Override
    public List<EIEntity> getInstitutions() throws LoggedException, InvalidSessionIdException {
        //SessionManager.validate(sessionId);
        try {
           
            return institutionRegistry.getInstitutions();
           
        } catch (Throwable t) {
            logger.error("Error in getInstitutions", t);
            throw new LoggedException(t.getLocalizedMessage());
        }        
    }
    
    @Override
    public Session logIn(String institutionId, String username, String password) throws LoggedException {
        try {
            
            return securityProvider.logIn(institutionId, username, password);
           
        } catch (Throwable t) {
            logger.error("Error in login", t);
            throw new LoggedException(t.getLocalizedMessage());
        }        
    }

    @Override
    public void logOut(String sessionId) {
        try {
            
            securityProvider.logOut(sessionId);
           
        } catch (Throwable t) {
            logger.error("Error in logout", t);
        }        
    }
    
    @Override
    public Session getSession(String sessionId) {
        try {
            
            return securityProvider.getSession(sessionId);
           
        } catch (Throwable t) {
            logger.error("Error in getSession", t);
            return null;        
        }
    }

}
