/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.instance;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.ui.gwt.instance.InstanceChangeListener;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemote;
import org.eaglei.ui.gwt.instance.rpc.InstanceServiceRemoteAsync;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

public class MaterializedPropertyWidget
extends Composite {
    private FlowPanel mainPanel;
    List<EIInstanceMinimal> instanceList = new ArrayList<EIInstanceMinimal>();
    FlowPanel materializedPanel;
    EIInstance eiInstance;
    private final InstanceChangeListener listener;
    private static final Map<String, String> typePlurals = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("Instrument", "Instruments");
            this.put("Technique", "Techniques");
            this.put("Service", "Services");
            this.put("Person", "People");
            this.put("Document", "Documents");
            this.put("Protocol", "Protocols");
            this.put("Software", "Software");
            this.put("Reagent", "Reagents");
            this.put("Human Study", "Human Studies");
            this.put("Organism or Virus", "Organisms and Viruses");
            this.put("Organization", "Organizations");
            this.put("Research Opportunity", "Research Opportunities");
            this.put("Biological Specimen", "Biological Specimens");
            this.put("Construct insert", "Construct Inserts");
            this.put("Construct Insert", "Construct Inserts");
        }
    };
    private static final Logger log = Logger.getLogger("MaterializedPropertyWidget");
    private int currentIndex;
    public static final InstanceServiceRemoteAsync instanceService = (InstanceServiceRemoteAsync)GWT.create(InstanceServiceRemote.class);
    private static final int INVERSE_PROPERTIES_COUNT = 10;

    public MaterializedPropertyWidget(EIInstance eiInstance, EIEntity propertyEntity, List<EIInstanceMinimal> eiInstanceMinimalList, FlowPanel mainPanel, InstanceChangeListener listener) {
        this.instanceList = eiInstanceMinimalList;
        this.mainPanel = mainPanel;
        this.materializedPanel = new FlowPanel();
        this.listener = listener;
        this.eiInstance = eiInstance;
        this.initWidget((Widget)this.materializedPanel);
        this.setup();
    }

    private void setup() {
        HashMap<EIEntity, List<EIInstanceMinimal>> instanceTypeMap = new HashMap<EIEntity, List<EIInstanceMinimal>>();
        for (EIInstanceMinimal eiInstanceMinimal : this.instanceList) {
            List<EIInstanceMinimal> instanceList;
            if (instanceTypeMap.containsKey(eiInstanceMinimal.getDataModelRootSuperClass())) {
                instanceList = (List)instanceTypeMap.get(eiInstanceMinimal.getDataModelRootSuperClass());
                if (instanceList == null) continue;
                instanceList.add(eiInstanceMinimal);
                continue;
            }
            instanceList = new ArrayList<EIInstanceMinimal>();
            instanceList.add(eiInstanceMinimal);
            instanceTypeMap.put(eiInstanceMinimal.getDataModelRootSuperClass(), instanceList);
        }
        for (EIEntity instanceType : instanceTypeMap.keySet()) {
            String label = typePlurals.get(instanceType.getLabel());
            if (label == null) {
                log.warning("no plural for " + instanceType.getLabel());
                label = instanceType.getLabel();
            }
            DisclosurePanel typePanel = new DisclosurePanel(label);
            typePanel.setStyleName("formPanelInside");
            FlowPanel innerPanel = new FlowPanel();
            this.materializedPanel.add((Widget)typePanel);
            List<EIInstanceMinimal> firstPageList = this.getFirstPage((List)instanceTypeMap.get(instanceType));
            this.displayResults(firstPageList, innerPanel);
            this.addNextLink(instanceTypeMap, instanceType, innerPanel);
            typePanel.setContent((Widget)innerPanel);
        }
    }

    private void addNextLink(final Map<EIEntity, List<EIInstanceMinimal>> instanceTypeMap, final EIEntity instanceType, final FlowPanel innerPanel) {
        if (this.getCurrentIndex() < instanceTypeMap.get(instanceType).size()) {
            Image next = new Image("images/pagination-rightarrow.png");
            next.setStyleName("nextLink");
            innerPanel.add((Widget)next);
            next.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    List<EIInstanceMinimal> nextPageList = MaterializedPropertyWidget.this.getNextPage((List)instanceTypeMap.get(instanceType));
                    MaterializedPropertyWidget.this.displayResults(nextPageList, innerPanel);
                    MaterializedPropertyWidget.this.addPrevLink(instanceTypeMap, instanceType, innerPanel);
                    MaterializedPropertyWidget.this.addNextLink(instanceTypeMap, instanceType, innerPanel);
                }
            });
        }
    }

    private void addPrevLink(final Map<EIEntity, List<EIInstanceMinimal>> instanceTypeMap, final EIEntity instanceType, final FlowPanel innerPanel) {
        if (this.getCurrentIndex() > 10) {
            Image prev = new Image("images/pagination-leftarrow.png");
            prev.setStyleName("prevLink");
            innerPanel.add((Widget)prev);
            prev.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    List<EIInstanceMinimal> prevPageList = MaterializedPropertyWidget.this.getPrevPage((List)instanceTypeMap.get(instanceType));
                    MaterializedPropertyWidget.this.displayResults(prevPageList, innerPanel);
                    MaterializedPropertyWidget.this.addPrevLink(instanceTypeMap, instanceType, innerPanel);
                    MaterializedPropertyWidget.this.addNextLink(instanceTypeMap, instanceType, innerPanel);
                }
            });
        }
    }

    private void displayResults(List<EIInstanceMinimal> eiInstanceMinimalList, final FlowPanel innerPanel) {
        innerPanel.clear();
        for (final EIInstanceMinimal instance : eiInstanceMinimalList) {
            ClientModelManager.INSTANCE.isModelClassURI(instance.getInstanceURI(), (AsyncCallback)new AsyncCallback<Boolean>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(Boolean result) {
                    if (result.booleanValue()) {
                        Label propertyValue = new Label(instance.getInstanceLabel());
                        innerPanel.add((Widget)propertyValue);
                    } else {
                        Anchor a = new Anchor(InstanceWidgetUtils.formatText(instance.getInstanceLabel()));
                        innerPanel.add((Widget)a);
                        a.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent arg0) {
                                log.fine("listener changing instance to " + instance.getInstanceURI());
                                History.newItem((String)("inst/uri=" + instance.getInstanceURI().toString()));
                                MaterializedPropertyWidget.this.listener.onInstanceChanged(instance.getInstanceURI());
                            }
                        });
                    }
                }
            });
        }
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public List<EIInstanceMinimal> getFirstPage(List<EIInstanceMinimal> instanceMinimalList) {
        return this.iterateFrom(0, instanceMinimalList);
    }

    public List<EIInstanceMinimal> getNextPage(List<EIInstanceMinimal> instanceMinimalList) {
        return this.iterateFrom(this.getCurrentIndex(), instanceMinimalList);
    }

    public List<EIInstanceMinimal> getPrevPage(List<EIInstanceMinimal> instanceMinimalList) {
        int newStart = this.getCurrentIndex() - 10;
        if (this.getCurrentIndex() % 10 != 0) {
            newStart = this.getCurrentIndex() - this.getCurrentIndex() % 10;
        }
        return this.iterateFrom(newStart -= 10, instanceMinimalList);
    }

    private List<EIInstanceMinimal> iterateFrom(int startIndex, List<EIInstanceMinimal> instanceList) {
        int endIndex;
        int totalSize = instanceList.size();
        this.currentIndex = endIndex = startIndex + 10;
        if (endIndex > totalSize) {
            endIndex = totalSize;
            this.currentIndex = totalSize;
        }
        return instanceList.subList(startIndex, endIndex);
    }
}

