/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.instance.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Label;
import java.util.HashMap;
import org.eaglei.model.EIEntity;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;

public class InstanceWidgetUtils {
    public static Label createLabel(EIEntity propertyEntity, String definition, boolean isRequired) {
        if (propertyEntity == null || propertyEntity == EIEntity.NULL_ENTITY) {
            return InstanceWidgetUtils.createLabel("", definition, isRequired);
        }
        if (EagleIEntityConstants.missingTooltips.containsKey(propertyEntity)) {
            return InstanceWidgetUtils.createLabel(propertyEntity.getLabel(), EagleIEntityConstants.missingTooltips.get(propertyEntity), isRequired);
        }
        return InstanceWidgetUtils.createLabel(propertyEntity.getLabel(), definition, isRequired);
    }

    public static Label createLabel(String label, String definition, boolean isRequired) {
        Label propertyLabel = label == null || "".equals(label) ? new Label(label) : new Label(InstanceWidgetUtils.capitalizeFirst(label));
        if (isRequired) {
            propertyLabel.setStyleName("formLabelRequired");
        } else {
            propertyLabel.setStyleName("formLabel");
        }
        if (definition != null && !"".equals(definition) && !"NO DEFINITION".equals(definition)) {
            propertyLabel.setTitle(definition);
        }
        return propertyLabel;
    }

    public static String getGlossaryURL() {
        String url = GWT.getHostPageBaseURL();
        String node = InstanceWidgetUtils.getNodeNameFromURL();
        if (node != null) {
            String searchUrl = url.replace(node + ".", "search.").replace("/institution/", "").replace("/datatools/", "") + "/model/";
            return searchUrl;
        }
        return null;
    }

    public static String getNodeNameFromURL() {
        String url = GWT.getHostPageBaseURL();
        return InstanceWidgetUtils.getNodeNameFromURL(url);
    }

    public static String getNodeNameFromURL(String url) {
        int startIndex = -1;
        int endIndex = url.indexOf(".eagle-i.net");
        startIndex = url.indexOf(".") > 0 && url.indexOf(".") < endIndex ? url.indexOf(".") + 1 : url.indexOf("//") + 2;
        if (endIndex == -1 || startIndex == -1) {
            return null;
        }
        String node = url.substring(startIndex, endIndex);
        return node;
    }

    public static String getUniversity(String instanceUri) {
        HashMap<String, String> shortNameToFullNameMap = new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("harvard", "Harvard University");
                this.put("upr", "University Of Puerto Rico Medical Sciences Campus");
                this.put("msm", "Morehouse School of Medicine");
                this.put("jsu", "Jackson State University");
                this.put("hawaii", "University of Hawaii at Manoa");
                this.put("ohsu", "Oregon Health & Science University");
                this.put("dartmouth", "Dartmouth College");
                this.put("montana", "Montana State University");
                this.put("alaska", "University of Alaska Fairbanks");
            }
        };
        String nodeName = InstanceWidgetUtils.getNodeNameFromURL(instanceUri);
        if (nodeName != null && shortNameToFullNameMap.containsKey(nodeName)) {
            return (String)shortNameToFullNameMap.get(nodeName);
        }
        return null;
    }

    public static String capitalizeFirst(String original) {
        char first = original.charAt(0);
        return Character.toUpperCase(first) + original.substring(1);
    }

    public static String formatText(String value) {
        if (value.indexOf("^") > 0) {
            return value.substring(0, value.indexOf("^"));
        }
        return value;
    }

    public static String getExtendedPropertyLabel(String typeLabel, String propertyName) {
        return InstanceWidgetUtils.capitalizeFirst(typeLabel) + " " + propertyName;
    }

    public static String insertBreaks(String value) {
        return value.replaceAll("(\r\n|\r|\n|\n\r)", "<br/>");
    }
}

