/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;

public class NavBar
extends Composite {
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    @UiField
    Element countLabel;
    @UiField
    Anchor previousButton;
    @UiField
    Anchor nextButton;
    private NavListener listener;

    public NavBar() {
        this.initWidget((Widget)binder.createAndBindUi((Object)this));
        this.previousButton.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                NavBar.this.previousButton.addStyleDependentName("hovering");
            }
        });
        this.previousButton.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                NavBar.this.previousButton.removeStyleDependentName("hovering");
            }
        });
        this.nextButton.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                NavBar.this.nextButton.addStyleDependentName("hovering");
            }
        });
        this.nextButton.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                NavBar.this.nextButton.removeStyleDependentName("hovering");
            }
        });
    }

    public void addNavListnener(NavListener listener) {
        this.listener = listener;
    }

    public void update(int startIndex, int count, int max) {
        this.setVisibility((Widget)this.previousButton, startIndex != 0);
        this.setVisibility((Widget)this.nextButton, startIndex + 10 < count);
        this.countLabel.setInnerText("" + (startIndex + 1) + " - " + max + " of " + count);
    }

    @UiHandler(value={"previousButton"})
    void onNewerClicked(ClickEvent event) {
        this.listener.onPreviousPage();
    }

    @UiHandler(value={"nextButton"})
    void onOlderClicked(ClickEvent event) {
        this.listener.onNextPage();
    }

    private void setVisibility(Widget widget, boolean visible) {
        widget.setVisible(visible);
    }

    public static interface NavListener {
        public void onPreviousPage();

        public void onNextPage();
    }

    @UiTemplate(value="NavBar.ui.xml")
    static interface Binder
    extends UiBinder<Widget, NavBar> {
    }
}

