/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.results;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.ui.gwt.search.SearchContext;
import org.eaglei.ui.gwt.search.rpc.ClientSearchResultSet;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemote;
import org.eaglei.ui.gwt.search.rpc.SearchServiceRemoteAsync;

public class RequestSummaryPanel
extends SimplePanel
implements SearchContext.SearchListener {
    private Label summaryLabel = new Label();
    private Map<EIURI, String> mapInstURIToLabel = null;

    public RequestSummaryPanel() {
        this.setStyleName("requestSummaryPanel");
        this.add((Widget)this.summaryLabel);
        this.summaryLabel.setStyleName("requestSummaryLabel");
        if (SearchContext.INSTANCE.getCurrentResults() != null) {
            this.onResults(SearchContext.INSTANCE.getCurrentResults());
        } else if (SearchContext.INSTANCE.getCurrentRequest() != null) {
            this.onRequestPending(SearchContext.INSTANCE.getCurrentRequest(), false);
        } else {
            this.setVisible(false);
        }
        SearchContext.INSTANCE.addListener(this);
        this.initInstitutionList();
    }

    @Override
    public void onFailure(SearchRequest request, String message) {
        this.setVisible(false);
    }

    @Override
    public void onRequestCreate(SearchRequest request) {
        this.setVisible(false);
    }

    @Override
    public void onRequestPending(SearchRequest request, boolean isPageRequest) {
        this.setVisible(false);
    }

    @Override
    public void onResults(ClientSearchResultSet results) {
        EIEntity bindingEntity = results.getBindingEntity();
        SearchRequest request = results.getResultSet().getRequest();
        boolean needsComma = false;
        StringBuilder buf = new StringBuilder("Search results for:  ");
        if (this.mapInstURIToLabel != null && request.getInstitution() != null) {
            buf.append(this.mapInstURIToLabel.get(request.getInstitution()));
            needsComma = true;
        }
        if (bindingEntity != null) {
            if (needsComma) {
                buf.append(", ");
            }
            buf.append(bindingEntity.getLabel());
            needsComma = true;
        }
        if (request.getTerm() != null && request.getTerm().getQuery() != null) {
            if (needsComma) {
                buf.append(", ");
            }
            buf.append("\"");
            buf.append(request.getTerm().getQuery());
            buf.append("\"");
            needsComma = true;
        }
        this.summaryLabel.setText(buf.toString());
        this.setVisible(needsComma);
    }

    private void initInstitutionList() {
        SearchServiceRemoteAsync searchService = (SearchServiceRemoteAsync)GWT.create(SearchServiceRemote.class);
        searchService.getInstitutions(new AsyncCallback<List<EIEntity>>(){

            public void onSuccess(List<EIEntity> result) {
                RequestSummaryPanel.this.mapInstURIToLabel = new HashMap(result.size());
                for (EIEntity entity : result) {
                    RequestSummaryPanel.this.mapInstURIToLabel.put(entity.getURI(), entity.getLabel());
                }
            }

            public void onFailure(Throwable caught) {
            }
        });
    }
}

