/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.search.sidebar;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.CountResult;
import org.eaglei.ui.gwt.ApplicationResources;

public abstract class AbstractCountNavigatorPanel
extends Composite {
    protected static final int MARGIN_INCREMENT = 6;
    private static final String STANDARD_TEXT_INDENT = "-10px";
    private static final String ARROW_TEXT_INDENT = "-14px";
    protected final FlowPanel outer = new FlowPanel();
    protected int currentMargin;
    private Image loadingImage = new Image(ApplicationResources.INSTANCE.loadingSmall());

    protected AbstractCountNavigatorPanel() {
        this.initWidget((Widget)this.outer);
        this.setStyleName("resourceList");
    }

    protected String createLabelString(String label, int count) {
        return label + " (" + count + ")";
    }

    protected String createLabelString(CountResult c) {
        return this.createLabelString(c.getEntity().getLabel(), c.getCount());
    }

    protected UIObject addLabel(CountResult c) {
        UIObject ui = this.addLabel(this.createLabelString(c), false);
        ui.setTitle(c.getDefinition());
        return ui;
    }

    protected UIObject addLabel(String labelString, boolean isItalic) {
        Label l = new Label(labelString);
        DOM.setStyleAttribute((Element)l.getElement(), (String)"textIndent", (String)STANDARD_TEXT_INDENT);
        DOM.setStyleAttribute((Element)l.getElement(), (String)"marginLeft", (String)(this.currentMargin + "px"));
        DOM.setStyleAttribute((Element)l.getElement(), (String)"marginBottom", (String)"1px");
        DOM.setStyleAttribute((Element)l.getElement(), (String)"fontWeight", (String)"bold");
        if (isItalic) {
            DOM.setStyleAttribute((Element)l.getElement(), (String)"fontStyle", (String)"italic");
        }
        this.outer.add((Widget)l);
        return l;
    }

    protected UIObject addAncestorLink(CountResult c) {
        UIObject ui = this.addLink(c, true, false);
        return ui;
    }

    protected UIObject addSubClassLink(CountResult c) {
        UIObject ui = this.addLink(c, false, c.hasSubEntity());
        return ui;
    }

    protected UIObject addLink(CountResult c, boolean displayArrow, boolean bold) {
        Label ui = this.addLink(this.createLabelString(c), c.getEntity().getURI(), false, displayArrow, bold);
        ui.setTitle(c.getDefinition());
        return ui;
    }

    protected Label addLink(String labelString, final EIURI entityURI, boolean isInferred, boolean displayArrow, boolean bold) {
        Label l;
        if (displayArrow) {
            l = new Label("< " + labelString);
            DOM.setStyleAttribute((Element)l.getElement(), (String)"textIndent", (String)ARROW_TEXT_INDENT);
        } else {
            l = new Label(labelString);
            DOM.setStyleAttribute((Element)l.getElement(), (String)"textIndent", (String)STANDARD_TEXT_INDENT);
        }
        DOM.setStyleAttribute((Element)l.getElement(), (String)"marginLeft", (String)(this.currentMargin + "px"));
        DOM.setStyleAttribute((Element)l.getElement(), (String)"marginBottom", (String)"1px");
        if (bold) {
            DOM.setStyleAttribute((Element)l.getElement(), (String)"fontWeight", (String)"bold");
        }
        l.setStyleName("link");
        if (isInferred) {
            l.addStyleDependentName("inferred");
        }
        l.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                l.addStyleDependentName("hovering");
            }
        });
        l.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                l.removeStyleDependentName("hovering");
            }
        });
        l.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                AbstractCountNavigatorPanel.this.onEntityClick(entityURI);
            }
        });
        this.outer.add((Widget)l);
        return l;
    }

    protected abstract void onEntityClick(EIURI var1);

    protected abstract String getAllLinkLabel();

    public void setRequestPending() {
        this.outer.clear();
        this.outer.add((Widget)this.loadingImage);
        DOM.setStyleAttribute((Element)this.loadingImage.getElement(), (String)"marginLeft", (String)(this.currentMargin + "px"));
    }

    protected void removeLoading() {
        this.outer.remove(this.outer.getWidgetCount() - 1);
    }
}

