/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.suggest;

import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.eaglei.ui.gwt.suggest.SearchSuggestOracle;
import org.eaglei.ui.gwt.suggest.SearchSuggestion;

public abstract class AbstractSearchBox
extends Composite {
    private String lastSetText = null;
    private SearchHandler handler = null;
    private SearchCommand searchCommand;
    protected final SuggestBox sbSearch;

    public AbstractSearchBox(String suggestBaseURL, String style) {
        this(new SearchSuggestOracle(suggestBaseURL), style);
    }

    public AbstractSearchBox(SuggestOracle oracle, String style) {
        this.sbSearch = new SuggestBox(oracle);
        if (style != null) {
            this.sbSearch.setStyleName(style);
        }
        this.sbSearch.setAutoSelectEnabled(false);
        this.sbSearch.setPopupStyleName("SearchBoxPopup");
        this.sbSearch.getTextBox().addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                if (AbstractSearchBox.this.getDefaultText().equals(AbstractSearchBox.this.sbSearch.getText())) {
                    AbstractSearchBox.this.setText("");
                }
            }
        });
        this.initWidget((Widget)this.sbSearch);
    }

    public SearchHandler getSearchHandler() {
        return this.handler;
    }

    public void addSelectionHandler(SelectionHandler<SuggestOracle.Suggestion> handler) {
        this.sbSearch.addSelectionHandler(handler);
    }

    public void addSearchHandler(SearchHandler handler, boolean notifyOnListSelect, boolean notifyOnEnter) {
        this.handler = handler;
        if (handler == null) {
            this.searchCommand = null;
            return;
        }
        this.searchCommand = new SearchCommand();
        if (notifyOnListSelect) {
            this.sbSearch.addSelectionHandler((SelectionHandler)new SelectionHandler<SuggestOracle.Suggestion>(){

                public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                    SearchSuggestion suggestion = (SearchSuggestion)event.getSelectedItem();
                    AbstractSearchBox.this.searchCommand.setSuggestQuery(suggestion);
                    DeferredCommand.addCommand((Command)AbstractSearchBox.this.searchCommand);
                }
            });
        }
        if (notifyOnEnter) {
            this.sbSearch.getTextBox().addKeyUpHandler(new KeyUpHandler(){

                public void onKeyUp(KeyUpEvent event) {
                    if (event.getNativeKeyCode() == 13) {
                        String query = AbstractSearchBox.this.sbSearch.getText().trim();
                        if (query.equals(AbstractSearchBox.this.lastSetText)) {
                            return;
                        }
                        AbstractSearchBox.this.searchCommand.setTextQuery(query, null);
                        DeferredCommand.addCommand((Command)AbstractSearchBox.this.searchCommand);
                    }
                }
            });
        }
    }

    protected SearchSuggestion getSuggestMatch() {
        String query = this.sbSearch.getText().trim();
        List<SearchSuggestion> listSuggestions = ((SearchSuggestOracle)this.sbSearch.getSuggestOracle()).getCurrentSuggestionList();
        if (listSuggestions != null) {
            String queryLower = query.toLowerCase();
            for (SearchSuggestion suggest : listSuggestions) {
                String suggestLower = suggest.getReplacementString().toLowerCase();
                if (!suggestLower.equals(queryLower)) continue;
                return suggest;
            }
        }
        return null;
    }

    public abstract String getDefaultText();

    public abstract String getSearchBaseURL();

    public String getText() {
        String query = this.sbSearch.getText().trim();
        if (this.getDefaultText().equals(query)) {
            return "";
        }
        return query;
    }

    public void setDefaultText() {
        this.sbSearch.setText(this.getDefaultText());
        this.sbSearch.addStyleDependentName("default");
    }

    public void setText(String text) {
        this.lastSetText = text;
        this.sbSearch.setText(text);
        this.sbSearch.removeStyleDependentName("default");
    }

    public String getLastSetText() {
        return this.lastSetText;
    }

    class SearchCommand
    implements Command {
        private String textQuery;
        private SearchSuggestion textSuggestion;
        private SearchSuggestion listSuggestion;

        SearchCommand() {
        }

        public void execute() {
            if (this.listSuggestion != null) {
                this.handleSearchSelected(this.listSuggestion.getReplacementString(), this.listSuggestion.getURIString());
            } else if (this.textSuggestion != null) {
                this.handleSearchSelected(this.textQuery, this.textSuggestion.getURIString());
            } else if (this.textQuery != null) {
                this.handleSearchSelected(this.textQuery, null);
            }
            this.textQuery = null;
            this.textSuggestion = null;
            this.listSuggestion = null;
        }

        public void setTextQuery(String textQuery, SearchSuggestion textSuggestion) {
            this.textQuery = textQuery;
            this.textSuggestion = textSuggestion;
        }

        public void setSuggestQuery(SearchSuggestion listChoice) {
            this.listSuggestion = listChoice;
        }

        private void handleSearchSelected(String query, String uri) {
            if (uri != null || query == null || query.length() == 0) {
                // empty if block
            }
            AbstractSearchBox.this.handler.performSearch(query, uri);
        }
    }

    public static interface SearchHandler {
        public void performSearch(String var1, String var2);
    }
}

