/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.ui.gwt.suggest.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.lexical.EntityMatch;
import org.eaglei.lexical.EntityMatchRequest;
import org.eaglei.lexical.SuggestionProvider;
import org.eaglei.model.EIURI;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DataSuggestServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected static final Log logger = LogFactory.getLog(DataSuggestServlet.class);
    protected static final boolean DEBUG = logger.isDebugEnabled();
    private SuggestionProvider provider;

    public void init() {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.provider = (SuggestionProvider)ctx.getBean("autoSuggestProvider");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        EntityMatchRequest entityRequest = null;
        try {
            String id = request.getParameter("id");
            String asyncCallback = request.getParameter("callback");
            entityRequest = DataSuggestServlet.createRequest(request);
            entityRequest.setMaxMatches(10);
            List suggestions = this.provider.suggest(entityRequest);
            StringBuilder sb = new StringBuilder();
            sb.append(asyncCallback);
            sb.append("({");
            DataSuggestServlet.writeJsonNameValueString(sb, "id", id);
            sb.append(',');
            sb.append("suggestions");
            sb.append(":[");
            if (suggestions != null && suggestions.size() > 0) {
                int i = 0;
                while (true) {
                    EntityMatch suggestion = (EntityMatch)suggestions.get(i++);
                    sb.append("\"");
                    sb.append(suggestion.getHighlight());
                    sb.append("\"");
                    sb.append(',');
                    DataSuggestServlet.writeJsonValueString(sb, suggestion.getMatchLabel());
                    sb.append(',');
                    DataSuggestServlet.writeJsonValueString(sb, suggestion.getEntity().getURI().toString());
                    sb.append(',');
                    DataSuggestServlet.writeJsonValueString(sb, suggestion.getRootTypeLabel() != null ? suggestion.getRootTypeLabel() : "<null>");
                    if (i == suggestions.size()) break;
                    sb.append(',');
                }
            }
            sb.append("]");
            sb.append("})");
            String output = sb.toString();
            response.setContentType("text/javascript");
            response.addHeader("Pragma", "no-cache");
            response.setStatus(200);
            PrintWriter out = response.getWriter();
            out.println(output);
        }
        catch (Throwable t) {
            logger.error((Object)("Unexpected error getting suggestions: request: " + entityRequest != null ? entityRequest.toString() : "null"), t);
            throw new ServletException(t);
        }
    }

    private static void writeJsonNameValueString(StringBuilder sb, String name, String value) {
        sb.append(name);
        sb.append(":");
        DataSuggestServlet.writeJsonValueString(sb, value);
    }

    private static void writeJsonValueString(StringBuilder sb, String value) {
        sb.append("\"");
        sb.append(value);
        sb.append("\"");
    }

    private static EntityMatchRequest createRequest(HttpServletRequest httpRequest) {
        String q = httpRequest.getParameter("q");
        q = q.substring(1, q.length() - 1);
        String classid = httpRequest.getParameter("bt");
        EntityMatchRequest searchRequest = null;
        if (classid == null) {
            searchRequest = new EntityMatchRequest(q);
        } else {
            String decodedClassId = URLDecoder.decode(classid);
            searchRequest = new EntityMatchRequest(q, EIURI.create((String)decodedClassId));
        }
        String property = httpRequest.getParameter("prop");
        if (property != null) {
            searchRequest.setProperty(property);
        }
        return searchRequest;
    }
}

