package org.eaglei.ui.gwt;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * This class manages a multi-page application.
 * 
 */
public class ApplicationContext {
    
    public interface ApplicationPage {
        void setPageParams(String params);
        Widget asWidget();
    }

    public static boolean IS_INSTITUTION;
    public static String TIER; // the current eagle-i.net tier, null for prod
    public static ApplicationContext INSTANCE;

    public static void setHistory(String pageToken, String pageParams) {
        assert (pageToken != null);
        StringBuilder buf = new StringBuilder(pageToken);
        if (pageParams != null) {
            buf.append(pageParams);
        }
        History.newItem(buf.toString());
    }

    public static void createApplicationContext(boolean isInstitution) {
        IS_INSTITUTION = isInstitution;
        String url = GWT.getHostPageBaseURL();
        int startIndex = url.indexOf("//");
        int endIndex = url.indexOf(".eagle-i.net");
        if (endIndex == -1 || startIndex == -1 || startIndex >= endIndex) {
            TIER = null;
        } else {
            startIndex += 2;
            String subdomain = url.substring(startIndex, endIndex);
            if (subdomain.indexOf('.') > 0) {
                // There's a tier and node segement.
                TIER = subdomain.substring(0, subdomain.indexOf('.'));
            }
        }
        INSTANCE = new ApplicationContext();
    }

    private ApplicationContext() {
/*        ApplicationResources.INSTANCE.nineSixtyCss().ensureInjected();
        ApplicationResources.INSTANCE.clientCss().ensureInjected();
        //ApplicationResources.INSTANCE.resetCss().ensureInjected();
        ApplicationResources.INSTANCE.advancedCss().ensureInjected();
        ApplicationResources.INSTANCE.globalAuxCss().ensureInjected();
        ApplicationResources.INSTANCE.globalCss().ensureInjected();
        ApplicationResources.INSTANCE.baseCss().ensureInjected();
        ApplicationResources.INSTANCE.panelStyleCss().ensureInjected();*/

        // Quick Hack
        TopPanel.HAS_INSTITUTION_SELECT = !IS_INSTITUTION;
        NewTopPanel.IS_INSTITUION = IS_INSTITUTION;
        
        RootPanel headerSlot = RootPanel.get("header_container_x");
        if (headerSlot != null) {
            //final TopPanel topPanel = new TopPanel();
            final NewTopPanel topPanel = new NewTopPanel();
            headerSlot.add(topPanel);
        } else {
            headerSlot = RootPanel.get("header_container");
            final TopPanel topPanel = new TopPanel();
            headerSlot.add(topPanel);
        }

        RootPanel footerSlot = RootPanel.get("footer_container_x");
        if (footerSlot != null) {
            String version = footerSlot.getElement().getInnerText();
            footerSlot.getElement().setInnerText("");
            //final FooterPanel footerPanel = new FooterPanel(version);
            final NewFooterPanel footerPanel = new NewFooterPanel(version);
            footerSlot.add(footerPanel);
        } else {
            footerSlot = RootPanel.get("footer_container");
            String version = footerSlot.getElement().getInnerText();
            footerSlot.getElement().setInnerText("");
            final FooterPanel footerPanel = new FooterPanel(version);
            footerSlot.add(footerPanel);
        }
    }
}
