package org.eaglei.ui.gwt;

import org.eaglei.model.EIInstance;
import org.eaglei.ui.gwt.instance.InstanceChangeListener;
import org.eaglei.ui.gwt.instance.InstancePanel;
import org.eaglei.ui.gwt.instance.MaterializedInversePropRenderer;
import org.eaglei.ui.gwt.instance.SearchOntologyPropViewRenderer;


public class SearchInstancePanel extends InstancePanel {
	
	public SearchInstancePanel(EIInstance instance, InstanceChangeListener listener) {
		
		super(instance);
		eiInstance = instance; 
		createRenderers(listener);
	}

	private void createRenderers(InstanceChangeListener listener) {
		ontologyPropRenderer = new SearchOntologyPropViewRenderer(eiInstance, ontologyPanel, listener);
		renderer = new MaterializedInversePropRenderer(eiInstance, materializedPropertiesPanel, listener);
	}
	
	@Override
	protected void initializeSpecifics() {
		formPanel.add(ontologyPanel);
		formPanel.add(materializedPropertiesPanel);
		outerFormPanel.add(formPanel);
	}
	
}
